/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.sling.api.resource.observation.ResourceChange;

public class JcrResourceChange
extends ResourceChange {
    private final String userId;

    private JcrResourceChange(Builder builder) {
        super(builder.changeType, builder.path, builder.isExternal, builder.addedAttributeNames, builder.changedAttributeNames, builder.removedAttributeNames);
        this.userId = builder.userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceChange[type=").append(this.getType()).append(", path=").append(this.getPath());
        if (this.getAddedPropertyNames() != null && !this.getAddedPropertyNames().isEmpty()) {
            b.append(", added=").append(this.getAddedPropertyNames());
        }
        if (this.getChangedPropertyNames() != null && !this.getChangedPropertyNames().isEmpty()) {
            b.append(", changed=").append(this.getChangedPropertyNames());
        }
        if (this.getRemovedPropertyNames() != null && !this.getRemovedPropertyNames().isEmpty()) {
            b.append(", removed=").append(this.getRemovedPropertyNames());
        }
        b.append("]");
        return b.toString();
    }

    public static class Builder {
        private String path;
        private ResourceChange.ChangeType changeType;
        private boolean isExternal;
        private String userId;
        private Set<String> changedAttributeNames;
        private Set<String> addedAttributeNames;
        private Set<String> removedAttributeNames;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public ResourceChange.ChangeType getChangeType() {
            return this.changeType;
        }

        public void setChangeType(ResourceChange.ChangeType changeType) {
            this.changeType = changeType;
        }

        public boolean isExternal() {
            return this.isExternal;
        }

        public void setExternal(boolean isExternal) {
            this.isExternal = isExternal;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public Set<String> getChangedAttributeNames() {
            return this.changedAttributeNames;
        }

        public void addChangedAttributeName(String propName) {
            if (this.changedAttributeNames == null) {
                this.changedAttributeNames = new LinkedHashSet<String>();
            }
            if (!this.changedAttributeNames.contains(propName)) {
                this.changedAttributeNames.add(propName);
            }
        }

        public Set<String> getAddedAttributeNames() {
            return this.addedAttributeNames;
        }

        public void addAddedAttributeName(String propName) {
            if (this.addedAttributeNames == null) {
                this.addedAttributeNames = new LinkedHashSet<String>();
            }
            if (!this.addedAttributeNames.contains(propName)) {
                this.addedAttributeNames.add(propName);
            }
        }

        public Set<String> getRemovedAttributeNames() {
            return this.removedAttributeNames;
        }

        public void addRemovedAttributeName(String propName) {
            if (this.removedAttributeNames == null) {
                this.removedAttributeNames = new LinkedHashSet<String>();
            }
            if (!this.removedAttributeNames.contains(propName)) {
                this.removedAttributeNames.add(propName);
            }
        }

        public ResourceChange build() {
            return new JcrResourceChange(this);
        }
    }
}

