/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.net.JCRJarURLHandler;
import org.apache.jackrabbit.net.JCRURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRJarURLConnection
extends JCRURLConnection {
    private static final Logger log = LoggerFactory.getLogger((Class)JCRJarURLConnection.class);
    protected static final String APPLICATION_JAR = "application/java-archive";

    JCRJarURLConnection(URL url, JCRJarURLHandler handler) {
        super(url, handler);
    }

    String getEntryPath() {
        return this.getFileParts().getEntryPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void connect() throws IOException {
        if (this.connected) return;
        super.connect();
        Property property = this.getProperty();
        String contentType = this.getContentType();
        String contentEncoding = this.getContentEncoding();
        int contentLength = this.getContentLength();
        long lastModified = this.getLastModified();
        this.connected = false;
        try {
            JarInputStream jins = null;
            try {
                jins = new JarInputStream(property.getStream());
                String entryPath = this.getEntryPath();
                if (entryPath != null) {
                    JarEntry entry = JCRJarURLConnection.findEntry(jins, entryPath);
                    if (entry == null) throw this.failure("connect", entryPath + " not contained in jar archive", null);
                    contentType = JCRJarURLConnection.guessContentTypeFromName(entryPath);
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    contentLength = (int)entry.getSize();
                    lastModified = entry.getTime();
                } else {
                    contentType = APPLICATION_JAR;
                }
            }
            finally {
                if (jins != null) {
                    try {
                        jins.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            log.debug("connect: Using atom '" + property.getPath() + "' with content type '" + contentType + "' for " + String.valueOf(contentLength) + " bytes");
            this.setContentType(contentType);
            this.setContentEncoding(contentEncoding);
            this.setContentLength(contentLength);
            this.setLastModified(lastModified);
            this.connected = true;
            return;
        }
        catch (RepositoryException re) {
            throw this.failure("connect", re.toString(), re);
        }
    }

    public InputStream getInputStream() throws IOException {
        InputStream ins = super.getInputStream();
        String entryPath = this.getEntryPath();
        if (entryPath != null) {
            JarInputStream jins = new JarInputStream(ins);
            JCRJarURLConnection.findEntry(jins, entryPath);
            return jins;
        }
        return ins;
    }

    static JarEntry findEntry(JarInputStream zins, String path) throws IOException {
        JarEntry entry = zins.getNextJarEntry();
        while (entry != null) {
            if (path.equals(entry.getName())) {
                return entry;
            }
            entry = zins.getNextJarEntry();
        }
        return null;
    }
}

