/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.i18n.impl.JcrResourceBundle;
import org.apache.sling.i18n.impl.RootResourceBundle;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceBundleProvider.class, ResourceChangeListener.class}, property={"service.description=Apache Sling I18n Resource Bundle Provider", "service.vendor=The Apache Software Foundation", "resource.paths=/"})
@Designate(ocd=Config.class)
public class JcrResourceBundleProvider
implements ResourceBundleProvider,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Pattern USER_ASSIGNED_COUNTRY_CODES_PATTERN = Pattern.compile("aa|q[m-z]|x[a-z]|zz");
    @Reference
    private Scheduler scheduler;
    private final Collection<String> scheduledJobNames = Collections.synchronizedList(new ArrayList());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    private volatile Locale defaultLocale = Locale.ENGLISH;
    private final ConcurrentHashMap<Key, JcrResourceBundle> resourceBundleCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Key, Semaphore> loadingGuards = new ConcurrentHashMap();
    private final Set<String> languageRootPaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile ResourceBundle rootResourceBundle;
    private volatile BundleContext bundleContext;
    private final Map<Key, ServiceRegistration<ResourceBundle>> bundleServiceRegistrations = new HashMap<Key, ServiceRegistration<ResourceBundle>>();
    private boolean preloadBundles;
    private long invalidationDelay;

    private ResourceResolver createResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    @Override
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        return this.getResourceBundleInternal(null, baseName, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(List<ResourceChange> changes) {
        ChangeStatus status = new ChangeStatus();
        try {
            for (ResourceChange change : changes) {
                this.onChange(status, change);
                if (!status.reloadAll) continue;
                break;
            }
            if (status.reloadAll) {
                this.scheduleReloadBundles(true);
            } else {
                for (JcrResourceBundle bundle : status.reloadBundles) {
                    this.scheduleReloadBundle(bundle);
                }
            }
        }
        catch (LoginException le) {
            this.log.error("Unable to get service resource resolver.", (Throwable)le);
        }
        finally {
            if (status.resourceResolver != null) {
                status.resourceResolver.close();
            }
        }
    }

    private void onChange(ChangeStatus status, ResourceChange change) throws LoginException {
        this.log.debug("onChange: Detecting change {} for path '{}'", (Object)change.getType(), (Object)change.getPath());
        if (this.languageRootPaths.contains(change.getPath())) {
            this.log.debug("onChange: Detected change of cached language root '{}', removing all cached ResourceBundles", (Object)change.getPath());
            status.reloadAll = true;
        } else {
            for (String root : this.languageRootPaths) {
                if (!change.getPath().startsWith(root)) continue;
                for (JcrResourceBundle bundle : this.resourceBundleCache.values()) {
                    if (!bundle.getLanguageRootPaths().contains(root)) continue;
                    this.log.debug("onChange: Resource changes below '{}', reloading ResourceBundle '{}'", (Object)root, (Object)bundle);
                    status.reloadBundles.add(bundle);
                }
            }
            if (status.resourceResolver == null) {
                status.resourceResolver = this.createResourceResolver();
            }
            if (this.isDictionaryResource(status.resourceResolver, change)) {
                status.reloadAll = true;
            }
        }
    }

    private boolean isDictionaryResource(ResourceResolver resolver, ResourceChange change) {
        Resource resource = resolver.getResource(change.getPath());
        if (resource == null) {
            this.log.trace("Could not get resource for '{}' for event {}", (Object)change.getPath(), (Object)change.getType());
            return false;
        }
        if (resource.getResourceType() == null) {
            return false;
        }
        if (resource.isResourceType("sling:MessageEntry")) {
            this.log.debug("Found new dictionary entry: New {} resource in '{}' detected", (Object)"sling:MessageEntry", (Object)change.getPath());
            return true;
        }
        ValueMap valueMap = resource.getValueMap();
        if (this.hasMixin(valueMap, "sling:Message")) {
            this.log.debug("Found new dictionary entry: New {} resource in '{}' detected", (Object)"sling:Message", (Object)change.getPath());
            return true;
        }
        if (change.getPath().endsWith(".json") && this.hasMixin(valueMap, "mix:language")) {
            this.log.debug("Found new dictionary: New {} resource in '{}' detected", (Object)"mix:language", (Object)change.getPath());
            return true;
        }
        return false;
    }

    private boolean hasMixin(ValueMap valueMap, String mixin) {
        String[] mixins = (String[])valueMap.get("jcr:mixinTypes", String[].class);
        if (mixins != null) {
            for (String m : mixins) {
                if (!mixin.equals(m)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReloadBundles(boolean withDelay) {
        Collection<String> collection = this.scheduledJobNames;
        synchronized (collection) {
            for (String scheduledJobName : this.scheduledJobNames) {
                this.scheduler.unschedule(scheduledJobName);
            }
        }
        this.scheduledJobNames.clear();
        ScheduleOptions options = withDelay ? this.scheduler.AT(new Date(System.currentTimeMillis() + this.invalidationDelay)) : this.scheduler.NOW();
        options.name("ResourceBundleProvider: reload all resource bundles");
        this.scheduler.schedule((Object)new Runnable(){

            @Override
            public void run() {
                JcrResourceBundleProvider.this.log.info("Reloading all resource bundles");
                JcrResourceBundleProvider.this.clearCache();
                JcrResourceBundleProvider.this.preloadBundles();
            }
        }, options);
    }

    private void scheduleReloadBundle(JcrResourceBundle bundle) {
        final Key key = new Key(bundle.getBaseName(), bundle.getLocale());
        ScheduleOptions options = this.scheduler.AT(new Date(System.currentTimeMillis() + this.invalidationDelay));
        final String jobName = "ResourceBundleProvider: reload bundle with key " + key.toString();
        this.scheduledJobNames.add(jobName);
        options.name(jobName);
        this.scheduler.schedule((Object)new Runnable(){

            @Override
            public void run() {
                JcrResourceBundleProvider.this.reloadBundle(key);
                JcrResourceBundleProvider.this.scheduledJobNames.remove(jobName);
            }
        }, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadBundle(Key key) {
        this.resourceBundleCache.remove(key);
        this.log.info("Reloading resource bundle for {}", (Object)key);
        ServiceRegistration<ResourceBundle> serviceRegistration = null;
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            serviceRegistration = this.bundleServiceRegistrations.remove(key);
        }
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        } else {
            this.log.warn("Could not find resource bundle service for {}", (Object)key);
        }
        ArrayList<JcrResourceBundle> dependentBundles = new ArrayList<JcrResourceBundle>();
        for (JcrResourceBundle bundle : this.resourceBundleCache.values()) {
            JcrResourceBundle parentBundle;
            Key parentKey;
            if (!(bundle.getParent() instanceof JcrResourceBundle) || !(parentKey = new Key((parentBundle = (JcrResourceBundle)bundle.getParent()).getBaseName(), parentBundle.getLocale())).equals(key)) continue;
            this.log.debug("Also invalidate dependent bundle {} which has bundle {} as parent", (Object)bundle, (Object)parentBundle);
            dependentBundles.add(bundle);
        }
        for (JcrResourceBundle dependentBundle : dependentBundles) {
            this.reloadBundle(new Key(dependentBundle.getBaseName(), dependentBundle.getLocale()));
        }
        if (this.preloadBundles) {
            this.getResourceBundle(key.baseName, key.locale);
        }
    }

    @Activate
    protected void activate(BundleContext context, Config config) throws LoginException {
        String localeString = config.locale_default();
        this.defaultLocale = JcrResourceBundleProvider.toLocale(localeString);
        this.preloadBundles = config.preload_bundles();
        this.bundleContext = context;
        this.invalidationDelay = config.invalidation_delay();
        if (this.resourceResolverFactory != null) {
            this.scheduleReloadBundles(false);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.clearCache();
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleInternal(ResourceResolver optionalResolver, String baseName, Locale locale) {
        JcrResourceBundle resourceBundle;
        Key key;
        block16: {
            key = new Key(baseName, locale);
            resourceBundle = this.resourceBundleCache.get(key);
            if (resourceBundle != null) {
                this.log.debug("getResourceBundleInternal({}): got cache hit on first try", (Object)key);
            } else {
                if (this.loadingGuards.get(key) == null) {
                    this.loadingGuards.putIfAbsent(key, new Semaphore(1));
                }
                Semaphore loadingGuard = this.loadingGuards.get(key);
                try {
                    loadingGuard.acquire();
                    resourceBundle = this.resourceBundleCache.get(key);
                    if (resourceBundle != null) {
                        this.log.debug("getResourceBundleInternal({}): got cache hit on second try", (Object)key);
                        break block16;
                    }
                    this.log.debug("getResourceBundleInternal({}): reading from Repository", (Object)key);
                    try (ResourceResolver localResolver = null;){
                        if (optionalResolver == null) {
                            optionalResolver = localResolver = this.createResourceResolver();
                        }
                        resourceBundle = this.createResourceBundle(optionalResolver, key.baseName, key.locale);
                        this.resourceBundleCache.put(key, resourceBundle);
                        this.registerResourceBundle(key, resourceBundle);
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                finally {
                    loadingGuard.release();
                }
            }
        }
        this.log.trace("getResourceBundleInternal({}) ==> {}", (Object)key, (Object)resourceBundle);
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerResourceBundle(Key key, JcrResourceBundle resourceBundle) {
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        if (key.baseName != null) {
            ((Dictionary)serviceProps).put("baseName", key.baseName);
        }
        ((Dictionary)serviceProps).put("locale", key.locale.toString());
        ServiceRegistration serviceReg = this.bundleContext.registerService(ResourceBundle.class, (Object)resourceBundle, serviceProps);
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            this.bundleServiceRegistrations.put(key, (ServiceRegistration<ResourceBundle>)serviceReg);
        }
        Set<String> languageRoots = resourceBundle.getLanguageRootPaths();
        this.languageRootPaths.addAll(languageRoots);
        this.log.debug("registerResourceBundle({}, ...): added service registration and language roots {}", (Object)key, languageRoots);
        this.log.info("Currently loaded dictionaries across all locales: {}", this.languageRootPaths);
    }

    private JcrResourceBundle createResourceBundle(ResourceResolver resolver, String baseName, Locale locale) {
        JcrResourceBundle bundle = new JcrResourceBundle(locale, baseName, resolver);
        Locale parentLocale = this.getParentLocale(locale);
        if (parentLocale != null) {
            bundle.setParent(this.getResourceBundleInternal(resolver, baseName, parentLocale));
        } else {
            bundle.setParent(this.getRootResourceBundle());
        }
        return bundle;
    }

    private Locale getParentLocale(Locale locale) {
        if (locale.getVariant().length() != 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry().length() != 0) {
            return new Locale(locale.getLanguage());
        }
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            return this.defaultLocale;
        }
        return null;
    }

    private ResourceBundle getRootResourceBundle() {
        if (this.rootResourceBundle == null) {
            this.rootResourceBundle = new RootResourceBundle();
        }
        return this.rootResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        ArrayList<ServiceRegistration<ResourceBundle>> regs;
        this.resourceBundleCache.clear();
        this.languageRootPaths.clear();
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            regs = new ArrayList<ServiceRegistration<ResourceBundle>>(this.bundleServiceRegistrations.values());
            this.bundleServiceRegistrations.clear();
        }
        for (ServiceRegistration serviceRegistration : regs) {
            serviceRegistration.unregister();
        }
    }

    private void preloadBundles() {
        if (this.preloadBundles) {
            try (ResourceResolver resolver = this.createResourceResolver();){
                Iterator bundles = resolver.queryResources("//element(*,mix:language)[@jcr:language]", "xpath");
                HashSet<Key> usedKeys = new HashSet<Key>();
                while (bundles.hasNext()) {
                    Key key;
                    Map bundle = (Map)bundles.next();
                    if (!bundle.containsKey("jcr:language")) continue;
                    Locale locale = JcrResourceBundleProvider.toLocale(bundle.get("jcr:language").toString());
                    String baseName = null;
                    if (bundle.containsKey("sling:basename")) {
                        baseName = bundle.get("sling:basename").toString();
                    }
                    if (!usedKeys.add(key = new Key(baseName, locale))) continue;
                    this.getResourceBundleInternal(resolver, baseName, locale);
                }
            }
            catch (LoginException le) {
                this.log.error("Unable to create service user resource resolver.", (Throwable)le);
            }
        }
    }

    static Locale toLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] parts = (localeString = localeString.replaceAll("-", "_")).split("_");
        if (parts.length == 0) {
            return Locale.getDefault();
        }
        String lang = parts[0];
        boolean isValidLanguageCode = false;
        String[] langs = Locale.getISOLanguages();
        for (int i = 0; i < langs.length; ++i) {
            if (!langs[i].equalsIgnoreCase(lang)) continue;
            isValidLanguageCode = true;
            break;
        }
        if (!isValidLanguageCode) {
            lang = Locale.getDefault().getLanguage();
        }
        if (parts.length == 1) {
            return new Locale(lang);
        }
        String country = parts[1];
        boolean isValidCountryCode = false;
        if (USER_ASSIGNED_COUNTRY_CODES_PATTERN.matcher(country.toLowerCase()).matches()) {
            isValidCountryCode = true;
        } else {
            String[] countries = Locale.getISOCountries();
            for (int i = 0; i < countries.length; ++i) {
                if (!countries[i].equalsIgnoreCase(country)) continue;
                isValidCountryCode = true;
                break;
            }
        }
        if (!isValidCountryCode) {
            country = Locale.getDefault().getCountry();
        }
        if (parts.length == 2) {
            return new Locale(lang, country);
        }
        return new Locale(lang, country, parts[2]);
    }

    protected static final class Key {
        final String baseName;
        final Locale locale;
        private final int hashCode;

        Key(String baseName, Locale locale) {
            int hc = 0;
            if (baseName != null) {
                hc += 17 * baseName.hashCode();
            }
            if (locale != null) {
                hc += 13 * locale.hashCode();
            }
            this.baseName = baseName;
            this.locale = locale;
            this.hashCode = hc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Key.equals(this.baseName, other.baseName) && Key.equals(this.locale, other.locale);
            }
            return false;
        }

        private static boolean equals(Object o1, Object o2) {
            return !(o1 == null ? o2 != null : !o1.equals(o2));
        }

        public String toString() {
            return "Key(" + this.baseName + ", " + this.locale + ")";
        }
    }

    private static final class ChangeStatus {
        public ResourceResolver resourceResolver;
        public boolean reloadAll = false;
        public final Set<JcrResourceBundle> reloadBundles = new HashSet<JcrResourceBundle>();

        private ChangeStatus() {
        }
    }

    @ObjectClassDefinition(name="Apache Sling I18N Resource Bundle Provider", description="ResourceBundleProvider service which loads the messages from the repository.")
    public static @interface Config {
        @AttributeDefinition(name="Default Locale", description="The default locale to assume if none can be resolved otherwise. This value must be in the form acceptable to the java.util.Locale class.")
        public String locale_default() default "en";

        @AttributeDefinition(name="Preload Bundles", description="Whether or not to eagerly load the resource bundles on bundle start or a cache invalidation.")
        public boolean preload_bundles() default false;

        @AttributeDefinition(name="Invalidation Delay", description="In case of dictionary change events the cached resource bundle becomes invalid after the given delay (in ms). ")
        public long invalidation_delay() default 5000L;
    }
}

