/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.logservice.internal;

import org.apache.sling.commons.logservice.internal.SLF4JSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private volatile ServiceTracker<LogReaderService, LogReaderService> logReaderTracker;

    public void start(final BundleContext context) throws Exception {
        Bundle systemBundle = context.getBundle(0L);
        final SLF4JSupport listener = new SLF4JSupport((FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class));
        this.logReaderTracker = new ServiceTracker(context, LogReaderService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<LogReaderService, LogReaderService>(){

            public LogReaderService addingService(ServiceReference<LogReaderService> reference) {
                LogReaderService srvc = (LogReaderService)context.getService(reference);
                if (srvc != null) {
                    srvc.addLogListener((LogListener)listener);
                    listener.replay(srvc.getLog());
                }
                return srvc;
            }

            public void modifiedService(ServiceReference<LogReaderService> reference, LogReaderService service) {
            }

            public void removedService(ServiceReference<LogReaderService> reference, LogReaderService service) {
                service.removeLogListener((LogListener)listener);
            }
        });
        this.logReaderTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logReaderTracker != null) {
            this.logReaderTracker.close();
            this.logReaderTracker = null;
        }
    }
}

