/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageAdminClassLoader
extends ClassLoader {
    private final PackageAdmin packageAdmin;
    private final DynamicClassLoaderManagerFactory factory;
    private Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private Set<String> negativeClassCache = Collections.synchronizedSet(new HashSet());
    private Map<String, URL> urlCache = new ConcurrentHashMap<String, URL>();

    public PackageAdminClassLoader(PackageAdmin pckAdmin, ClassLoader parent, DynamicClassLoaderManagerFactory factory) {
        super(parent);
        this.packageAdmin = pckAdmin;
        this.factory = factory;
    }

    private boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    private Bundle findBundleForPackage(String pckName) {
        ExportedPackage exportedPackage = this.packageAdmin.getExportedPackage(pckName);
        Bundle bundle = null;
        if (exportedPackage != null && !exportedPackage.isRemovalPending() && !this.isBundleActive(bundle = exportedPackage.getExportingBundle())) {
            bundle = null;
        }
        return bundle;
    }

    private String getPackageFromResource(String resource) {
        int lastSlash = resource.lastIndexOf(47);
        String pckName = lastSlash == -1 ? "" : resource.substring(0, lastSlash).replace('/', '.');
        return pckName;
    }

    private String getPackageFromClassName(String name) {
        int lastDot = name.lastIndexOf(46);
        String pckName = lastDot == -1 ? "" : name.substring(0, lastDot);
        return pckName;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Bundle bundle;
        Enumeration e = super.getResources(name);
        if (!(e != null && e.hasMoreElements() || (bundle = this.findBundleForPackage(this.getPackageFromResource(name))) == null)) {
            e = bundle.getResources(name);
        }
        return e;
    }

    @Override
    public URL findResource(String name) {
        Bundle bundle;
        URL cachedURL = this.urlCache.get(name);
        if (cachedURL != null) {
            return cachedURL;
        }
        URL url = super.findResource(name);
        if (url == null && (bundle = this.findBundleForPackage(this.getPackageFromResource(name))) != null && (url = bundle.getResource(name)) != null) {
            this.urlCache.put(name, url);
        }
        return url;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz;
        block4: {
            Class<?> cachedClass = this.classCache.get(name);
            if (cachedClass != null) {
                return cachedClass;
            }
            clazz = null;
            try {
                clazz = super.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                Bundle bundle = this.findBundleForPackage(this.getPackageFromClassName(name));
                if (bundle == null) break block4;
                clazz = bundle.loadClass(name);
                this.factory.addUsedBundle(bundle);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class not found " + name);
        }
        this.classCache.put(name, clazz);
        return clazz;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz;
        block7: {
            Class<?> cachedClass = this.classCache.get(name);
            if (cachedClass != null) {
                return cachedClass;
            }
            if (this.negativeClassCache.contains(name)) {
                throw new ClassNotFoundException("Class not found " + name);
            }
            clazz = null;
            try {
                clazz = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                String pckName = this.getPackageFromClassName(name);
                Bundle bundle = this.findBundleForPackage(pckName);
                if (bundle == null) break block7;
                try {
                    clazz = bundle.loadClass(name);
                    this.factory.addUsedBundle(bundle);
                }
                catch (ClassNotFoundException inner) {
                    this.negativeClassCache.add(name);
                    this.factory.addUnresolvedPackage(pckName);
                    throw inner;
                }
            }
        }
        if (clazz == null) {
            this.negativeClassCache.add(name);
            String pckName = this.getPackageFromClassName(name);
            this.factory.addUnresolvedPackage(pckName);
            throw new ClassNotFoundException("Class not found " + name);
        }
        this.classCache.put(name, clazz);
        return clazz;
    }
}

