/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.def;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.caconfig.impl.ConfigurationResourceWrapper;
import org.apache.sling.caconfig.resource.impl.util.PropertyUtil;
import org.apache.sling.caconfig.spi.ConfigurationInheritanceStrategy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationInheritanceStrategy.class})
@Designate(ocd=Config.class)
public class DefaultConfigurationInheritanceStrategy
implements ConfigurationInheritanceStrategy {
    private Config config;
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationInheritanceStrategy.class);

    @Activate
    private void activate(Config config) {
        this.config = config;
    }

    public Resource getResource(Iterator<Resource> configResources) {
        if (!this.config.enabled()) {
            return null;
        }
        if (!configResources.hasNext()) {
            return null;
        }
        Resource primary = configResources.next();
        if (!this.isPropertyInheritance(primary) || !configResources.hasNext()) {
            return primary;
        }
        Map<String, Object> mergedProps = this.getInheritedProperties((Map<String, Object>)primary.getValueMap(), configResources);
        return new ConfigurationResourceWrapper(primary, (ValueMap)new ValueMapDecorator(mergedProps));
    }

    private boolean isPropertyInheritance(Resource resource) {
        return PropertyUtil.getBooleanValueAdditionalKeys(resource.getValueMap(), "sling:configPropertyInherit", this.config.configPropertyInheritancePropertyNames());
    }

    private Map<String, Object> getInheritedProperties(Map<String, Object> parentProps, Iterator<Resource> inheritanceChain) {
        if (!inheritanceChain.hasNext()) {
            return parentProps;
        }
        Resource next = inheritanceChain.next();
        log.trace("! Property inheritance: Merge with properties from {}", (Object)next.getPath());
        HashMap<String, Object> merged = new HashMap<String, Object>((Map<String, Object>)next.getValueMap());
        merged.putAll(parentProps);
        if (this.isPropertyInheritance(next)) {
            return this.getInheritedProperties(merged, inheritanceChain);
        }
        return merged;
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Default Inheritance Strategy", description="Standardized resource inheritance for configurations.")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this configuration inheritance strategy.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Config property inheritance property names", description="Additional property names to sling:configPropertyInherit to handle property inheritance. The names are used in the order defined, always starting with sling:configPropertyInherit. Once a property with a value is found, that value is used and the following property names are skipped.")
        public String[] configPropertyInheritancePropertyNames();
    }
}

