/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.adapter.internal.AdapterManagerImpl;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Adapter Web Console Plugin"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="felix.webconsole.label", value={"adapters"}), @Property(name="felix.webconsole.title", value={"Sling Adapters"}), @Property(name="felix.webconsole.css", value={"/adapters/res/ui/adapters.css"}), @Property(name="felix.webconsole.configprinter.modes", value={"always"}), @Property(name="felix.webconsole.category", value={"Sling"})})
public class AdapterWebConsolePlugin
extends HttpServlet
implements ServiceTrackerCustomizer,
BundleListener {
    private static final int INDENT = 4;
    private static final String ADAPTER_CONDITION = "adapter.condition";
    private static final String ADAPTER_DEPRECATED = "adapter.deprecated";
    private final Logger logger = LoggerFactory.getLogger(AdapterWebConsolePlugin.class);
    @Reference
    private PackageAdmin packageAdmin;
    private List<AdaptableDescription> allAdaptables;
    private Map<ServiceReference, List<AdaptableDescription>> adapterServiceReferences;
    private Map<Bundle, List<AdaptableDescription>> adapterBundles;
    private ServiceTracker adapterTracker;
    private BundleContext bundleContext;

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        this.addServiceMetadata(reference, service);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceMetadata(ServiceReference reference, Object service) {
        String[] adapters = PropertiesUtil.toStringArray((Object)reference.getProperty("adapters"));
        String condition = PropertiesUtil.toString((Object)reference.getProperty(ADAPTER_CONDITION), null);
        boolean deprecated = PropertiesUtil.toBoolean((Object)reference.getProperty(ADAPTER_DEPRECATED), (boolean)false);
        String[] adaptables = PropertiesUtil.toStringArray((Object)reference.getProperty("adaptables"));
        ArrayList<AdaptableDescription> descriptions = new ArrayList<AdaptableDescription>(adaptables.length);
        for (String adaptable : adaptables) {
            descriptions.add(new AdaptableDescription(reference.getBundle(), adaptable, adapters, condition, deprecated));
        }
        AdapterWebConsolePlugin adapterWebConsolePlugin = this;
        synchronized (adapterWebConsolePlugin) {
            this.adapterServiceReferences.put(reference, descriptions);
            this.update();
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.removeBundle(event.getBundle());
        } else if (event.getType() == 2) {
            this.addBundle(event.getBundle());
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.addServiceMetadata(reference, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        AdapterWebConsolePlugin adapterWebConsolePlugin = this;
        synchronized (adapterWebConsolePlugin) {
            this.adapterServiceReferences.remove(reference);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBundle(Bundle bundle) {
        block10: {
            ArrayList<AdaptableDescription> descs = new ArrayList<AdaptableDescription>();
            try {
                Enumeration files = bundle.getResources("SLING-INF/adapters.json");
                if (files != null) {
                    while (files.hasMoreElements()) {
                        InputStream stream = ((URL)files.nextElement()).openStream();
                        String contents = IOUtils.toString((InputStream)stream);
                        IOUtils.closeQuietly((InputStream)stream);
                        JSONObject obj = new JSONObject(contents);
                        Iterator adaptableNames = obj.keys();
                        while (adaptableNames.hasNext()) {
                            String adaptableName = (String)adaptableNames.next();
                            JSONObject adaptable = obj.getJSONObject(adaptableName);
                            Iterator conditions = adaptable.keys();
                            while (conditions.hasNext()) {
                                String condition = (String)conditions.next();
                                Object value = adaptable.get(condition);
                                String[] adapters = value instanceof JSONArray ? this.toStringArray((JSONArray)value) : new String[]{value.toString()};
                                descs.add(new AdaptableDescription(bundle, adaptableName, adapters, condition, false));
                            }
                        }
                    }
                }
                if (descs.isEmpty()) break block10;
                AdapterWebConsolePlugin adapterWebConsolePlugin = this;
                synchronized (adapterWebConsolePlugin) {
                    this.adapterBundles.put(bundle, descs);
                    this.update();
                }
            }
            catch (IOException e) {
                this.logger.error("Unable to load adapter descriptors for bundle " + bundle, (Throwable)e);
            }
            catch (JSONException e) {
                this.logger.error("Unable to load adapter descriptors for bundle " + bundle, (Throwable)e);
            }
        }
    }

    private String[] toStringArray(JSONArray value) throws JSONException {
        ArrayList<String> result = new ArrayList<String>(value.length());
        for (int i = 0; i < value.length(); ++i) {
            result.add(value.getString(i));
        }
        return result.toArray(new String[value.length()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBundle(Bundle bundle) {
        AdapterWebConsolePlugin adapterWebConsolePlugin = this;
        synchronized (adapterWebConsolePlugin) {
            this.adapterBundles.remove(bundle);
            this.update();
        }
    }

    private void update() {
        ArrayList<AdaptableDescription> newList = new ArrayList<AdaptableDescription>();
        for (List<AdaptableDescription> descriptions : this.adapterServiceReferences.values()) {
            newList.addAll(descriptions);
        }
        for (List<AdaptableDescription> list : this.adapterBundles.values()) {
            newList.addAll(list);
        }
        Collections.sort(newList);
        this.allAdaptables = newList;
    }

    protected void activate(ComponentContext ctx) throws InvalidSyntaxException {
        this.bundleContext = ctx.getBundleContext();
        this.adapterServiceReferences = new HashMap<ServiceReference, List<AdaptableDescription>>();
        this.adapterBundles = new HashMap<Bundle, List<AdaptableDescription>>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.addBundle(bundle);
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        Filter filter = this.bundleContext.createFilter("(&(adaptables=*)(adapters=*)(objectClass=" + AdapterFactory.SERVICE_NAME + "))");
        this.adapterTracker = new ServiceTracker(this.bundleContext, filter, (ServiceTrackerCustomizer)this);
        this.adapterTracker.open();
    }

    protected void deactivate(ComponentContext ctx) {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.adapterTracker.close();
        this.adapterServiceReferences = null;
        this.adapterBundles = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo().endsWith("/data.json")) {
            this.getJson(resp);
        } else {
            this.getHtml(resp);
        }
    }

    private void getJson(HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        try {
            JSONObject obj = new JSONObject();
            for (AdaptableDescription desc : this.allAdaptables) {
                JSONObject adaptableObj;
                if (obj.has(desc.adaptable)) {
                    adaptableObj = obj.getJSONObject(desc.adaptable);
                } else {
                    adaptableObj = new JSONObject();
                    obj.put(desc.adaptable, (Object)adaptableObj);
                }
                for (String adapter : desc.adapters) {
                    adaptableObj.accumulate(desc.condition == null ? "" : desc.condition, (Object)adapter);
                }
            }
            resp.getWriter().println(obj.toString(4));
        }
        catch (JSONException e) {
            throw new ServletException("Unable to produce JSON", (Throwable)e);
        }
    }

    private void getHtml(HttpServletResponse resp) throws IOException {
        PrintWriter writer = resp.getWriter();
        writer.println("<p class=\"statline ui-state-highlight\">${Introduction}</p>");
        writer.println("<p>${intro}</p>");
        writer.println("<p class=\"statline ui-state-highlight\">${How to Use This Information}</p>");
        writer.println("<p>${usage}</p>");
        writer.println("<table class=\"adapters nicetable\">");
        writer.println("<thead><tr><th class=\"header\">${Adaptable Class}</th><th class=\"header\">${Adapter Class}</th><th class=\"header\">${Condition}</th><th class=\"header\">${Deprecated}</th><th class=\"header\">${Providing Bundle}</th></tr></thead>");
        String rowClass = "odd";
        for (AdaptableDescription desc : this.allAdaptables) {
            writer.printf("<tr class=\"%s ui-state-default\"><td>", rowClass);
            boolean packageExported = AdapterManagerImpl.checkPackage(this.packageAdmin, desc.adaptable);
            if (!packageExported) {
                writer.print("<span class='error'>");
            }
            writer.print(desc.adaptable);
            if (!packageExported) {
                writer.print("</span>");
            }
            writer.print("</td>");
            writer.print("<td>");
            for (String adapter : desc.adapters) {
                packageExported = AdapterManagerImpl.checkPackage(this.packageAdmin, adapter);
                if (!packageExported) {
                    writer.print("<span class='error'>");
                }
                writer.print(adapter);
                if (!packageExported) {
                    writer.print("</span>");
                }
                writer.print("<br/>");
            }
            writer.print("</td>");
            if (desc.condition == null) {
                writer.print("<td>&nbsp;</td>");
            } else {
                writer.printf("<td>%s</td>", desc.condition);
            }
            if (desc.deprecated) {
                writer.print("<td>${Deprecated}</td>");
            } else {
                writer.print("<td></td>");
            }
            writer.printf("<td><a href=\"${pluginRoot}/../bundles/%s\">%s (%s)</a></td>", desc.bundle.getBundleId(), desc.bundle.getSymbolicName(), desc.bundle.getBundleId());
            writer.println("</tr>");
            if (rowClass.equals("odd")) {
                rowClass = "even";
                continue;
            }
            rowClass = "odd";
        }
        writer.println("</table>");
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Adaptables:");
        for (AdaptableDescription desc : this.allAdaptables) {
            pw.printf("Adaptable: %s\n", desc.adaptable);
            if (desc.condition != null) {
                pw.printf("Condition: %s\n", desc.condition);
            }
            pw.printf("Providing Bundle: %s\n", desc.bundle.getSymbolicName());
            pw.printf("Available Adapters:\n", new Object[0]);
            for (String adapter : desc.adapters) {
                pw.print(" * ");
                pw.println(adapter);
            }
            pw.println();
        }
    }

    private URL getResource(String path) {
        if (path.startsWith("/adapters/res/ui/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(9));
        }
        return null;
    }

    protected void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected void unbindPackageAdmin(PackageAdmin packageAdmin) {
        if (this.packageAdmin == packageAdmin) {
            this.packageAdmin = null;
        }
    }

    class AdaptableDescription
    implements Comparable<AdaptableDescription> {
        private final String adaptable;
        private final String[] adapters;
        private final String condition;
        private final Bundle bundle;
        private final boolean deprecated;

        public AdaptableDescription(Bundle bundle, String adaptable, String[] adapters, String condition, boolean deprecated) {
            this.adaptable = adaptable;
            this.adapters = adapters;
            this.condition = condition;
            this.bundle = bundle;
            this.deprecated = deprecated;
        }

        public String toString() {
            return "AdapterDescription [adaptable=" + this.adaptable + ", adapters=" + Arrays.toString(this.adapters) + ", condition=" + this.condition + ", bundle=" + this.bundle + ", deprecated= " + this.deprecated + "]";
        }

        @Override
        public int compareTo(AdaptableDescription o) {
            return new CompareToBuilder().append((Object)this.adaptable, (Object)o.adaptable).append((Object)this.condition, (Object)o.condition).append(this.adapters.length, o.adapters.length).append(this.bundle.getBundleId(), o.bundle.getBundleId()).toComparison();
        }
    }
}

