/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdClient.class);
    private final Client client;
    private final ConcurrentHashMap<String, Watch.Watcher> watchCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Watch.Watcher> watchChildCache = new ConcurrentHashMap();

    public EtcdClient(Client client) {
        this.client = client;
    }

    public void close() {
        this.client.close();
    }

    public String get(String key) {
        List keyValues = null;
        try {
            keyValues = ((GetResponse)this.client.getKVClient().get(this.bytesOf(key)).get()).getKvs();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("get key error, key:{}", (Object)key, (Object)e);
        }
        if (CollectionUtils.isEmpty(keyValues)) {
            LOG.warn("get key {} is empty", (Object)key);
            return null;
        }
        return ((KeyValue)keyValues.iterator().next()).getValue().toString(StandardCharsets.UTF_8);
    }

    public Map<String, String> getKeysMapByPrefix(String prefix) {
        GetOption getOption = GetOption.newBuilder().isPrefix(true).build();
        try {
            return ((GetResponse)this.client.getKVClient().get(this.bytesOf(prefix), getOption).get()).getKvs().stream().collect(Collectors.toMap(e -> e.getKey().toString(StandardCharsets.UTF_8), e -> e.getValue().toString(StandardCharsets.UTF_8)));
        }
        catch (InterruptedException | ExecutionException e2) {
            LOG.error("etcd getKeysMapByPrefix key {} error", (Object)prefix, (Object)e2);
            throw new ShenyuException((Throwable)e2);
        }
    }

    public ByteSequence bytesOf(String val) {
        return ByteSequence.from((String)val, (Charset)StandardCharsets.UTF_8);
    }

    public List<String> getChildrenKeys(String prefix, String separator) throws ExecutionException, InterruptedException {
        ByteSequence prefixByteSequence = this.bytesOf(prefix);
        GetOption getOption = GetOption.newBuilder().withPrefix(prefixByteSequence).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build();
        List keyValues = ((GetResponse)this.client.getKVClient().get(prefixByteSequence, getOption).get()).getKvs();
        return keyValues.stream().map(e -> this.getSubNodeKeyName(prefix, e.getKey().toString(StandardCharsets.UTF_8), separator)).distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<String> getChildrenKeysByMap(String prefix, String separator, Map<String, String> map) {
        return map.entrySet().stream().filter(e -> ((String)e.getKey()).contains(prefix)).map(e -> this.getSubNodeKeyName(prefix, (String)e.getKey(), separator)).distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getSubNodeKeyName(String prefix, String fullPath, String separator) {
        if (prefix.length() > fullPath.length()) {
            return null;
        }
        String pathWithoutPrefix = fullPath.substring(prefix.length());
        return pathWithoutPrefix.contains(separator) ? pathWithoutPrefix.substring(1) : pathWithoutPrefix;
    }

    public void watchDataChange(String key, BiConsumer<String, String> updateHandler, Consumer<String> deleteHandler) {
        Watch.Listener listener = this.watch(updateHandler, deleteHandler);
        if (!this.watchCache.containsKey(key)) {
            Watch.Watcher watch = this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), listener);
            this.watchCache.put(key, watch);
        }
    }

    public void watchChildChange(String key, BiConsumer<String, String> updateHandler, Consumer<String> deleteHandler) {
        Watch.Listener listener = this.watch(updateHandler, deleteHandler);
        WatchOption option = WatchOption.newBuilder().withPrefix(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).build();
        if (!this.watchChildCache.containsKey(key)) {
            Watch.Watcher watch = this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), option, listener);
            this.watchChildCache.put(key, watch);
        }
    }

    private Watch.Listener watch(BiConsumer<String, String> updateHandler, Consumer<String> deleteHandler) {
        return Watch.listener(response -> {
            block4: for (WatchEvent event : response.getEvents()) {
                String path = event.getKeyValue().getKey().toString(StandardCharsets.UTF_8);
                String value = event.getKeyValue().getValue().toString(StandardCharsets.UTF_8);
                switch (event.getEventType()) {
                    case PUT: {
                        Optional.ofNullable(updateHandler).ifPresent(handler -> handler.accept(path, value));
                        continue block4;
                    }
                    case DELETE: {
                        Optional.ofNullable(deleteHandler).ifPresent(handler -> handler.accept(path));
                        continue block4;
                    }
                }
            }
        }, throwable -> {
            LOG.error("etcd watch error {}", (Object)throwable.getMessage(), throwable);
            throw new ShenyuException(throwable);
        });
    }

    public void watchClose(String key) {
        if (this.watchCache.containsKey(key)) {
            this.watchCache.get(key).close();
            this.watchCache.remove(key);
        }
        if (this.watchChildCache.containsKey(key)) {
            this.watchChildCache.get(key).close();
            this.watchChildCache.remove(key);
        }
    }
}

