/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.annotation;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.ctrip.framework.apollo.spring.annotation.ApolloJsonValue;
import com.ctrip.framework.apollo.spring.annotation.ApolloProcessor;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValue;
import com.ctrip.framework.apollo.spring.property.SpringValueRegistry;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class ApolloAnnotationProcessor
extends ApolloProcessor
implements BeanFactoryAware,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(ApolloAnnotationProcessor.class);
    private static final String NAMESPACE_DELIMITER = ",";
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on(",").omitEmptyStrings().trimResults();
    private static final Gson GSON = new Gson();
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private ConfigurableBeanFactory configurableBeanFactory;
    private Environment environment;

    @Override
    protected void processField(Object bean2, String beanName, Field field) {
        this.processApolloConfig(bean2, field);
        this.processApolloJsonValue(bean2, beanName, field);
    }

    @Override
    protected void processMethod(Object bean2, String beanName, Method method) {
        this.processApolloConfigChangeListener(bean2, method);
        this.processApolloJsonValue(bean2, beanName, method);
    }

    private void processApolloConfig(Object bean2, Field field) {
        ApolloConfig annotation = AnnotationUtils.getAnnotation(field, ApolloConfig.class);
        if (annotation == null) {
            return;
        }
        Preconditions.checkArgument(Config.class.isAssignableFrom(field.getType()), "Invalid type: %s for field: %s, should be Config", field.getType(), (Object)field);
        String namespace = annotation.value();
        String resolvedNamespace = this.environment.resolveRequiredPlaceholders(namespace);
        Config config = ConfigService.getConfig(resolvedNamespace);
        ReflectionUtils.makeAccessible(field);
        ReflectionUtils.setField(field, bean2, config);
    }

    private void processApolloConfigChangeListener(Object bean2, Method method) {
        ApolloConfigChangeListener annotation = AnnotationUtils.findAnnotation(method, ApolloConfigChangeListener.class);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument(parameterTypes.length == 1, "Invalid number of parameters: %s for method: %s, should be 1", parameterTypes.length, (Object)method);
        Preconditions.checkArgument(ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0]), "Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", parameterTypes[0], (Object)method);
        ReflectionUtils.makeAccessible(method);
        String[] namespaces = annotation.value();
        String[] annotatedInterestedKeys = annotation.interestedKeys();
        String[] annotatedInterestedKeyPrefixes = annotation.interestedKeyPrefixes();
        ConfigChangeListener configChangeListener = changeEvent -> ReflectionUtils.invokeMethod(method, bean2, changeEvent);
        HashSet<String> interestedKeys = annotatedInterestedKeys.length > 0 ? Sets.newHashSet(annotatedInterestedKeys) : null;
        HashSet<String> interestedKeyPrefixes = annotatedInterestedKeyPrefixes.length > 0 ? Sets.newHashSet(annotatedInterestedKeyPrefixes) : null;
        Set<String> resolvedNamespaces = this.processResolveNamespaceValue(namespaces);
        for (String namespace : resolvedNamespaces) {
            Config config = ConfigService.getConfig(namespace);
            if (interestedKeys == null && interestedKeyPrefixes == null) {
                config.addChangeListener(configChangeListener);
                continue;
            }
            config.addChangeListener(configChangeListener, interestedKeys, interestedKeyPrefixes);
        }
    }

    private Set<String> processResolveNamespaceValue(String[] namespaces) {
        HashSet<String> resolvedNamespaces = new HashSet<String>();
        for (String namespace : namespaces) {
            String resolvedNamespace = this.environment.resolveRequiredPlaceholders(namespace);
            if (resolvedNamespace.contains(NAMESPACE_DELIMITER)) {
                resolvedNamespaces.addAll(NAMESPACE_SPLITTER.splitToList(resolvedNamespace));
                continue;
            }
            resolvedNamespaces.add(resolvedNamespace);
        }
        return resolvedNamespaces;
    }

    private void processApolloJsonValue(Object bean2, String beanName, Field field) {
        ApolloJsonValue apolloJsonValue = AnnotationUtils.getAnnotation(field, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeholder = apolloJsonValue.value();
        Object propertyValue = this.resolvePropertyValue(beanName, placeholder);
        if (propertyValue == null) {
            return;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        ReflectionUtils.setField(field, bean2, this.parseJsonValue((String)propertyValue, field.getGenericType()));
        field.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeholder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, placeholder, bean2, beanName, field, true);
                this.springValueRegistry.register(this.configurableBeanFactory, key, springValue);
                logger.debug("Monitoring {}", (Object)springValue);
            }
        }
    }

    private void processApolloJsonValue(Object bean2, String beanName, Method method) {
        ApolloJsonValue apolloJsonValue = AnnotationUtils.getAnnotation(method, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeHolder = apolloJsonValue.value();
        Object propertyValue = this.resolvePropertyValue(beanName, placeHolder);
        if (propertyValue == null) {
            return;
        }
        Type[] types = method.getGenericParameterTypes();
        Preconditions.checkArgument(types.length == 1, "Ignore @ApolloJsonValue setter {}.{}, expecting 1 parameter, actual {} parameters", (Object)bean2.getClass().getName(), (Object)method.getName(), (Object)method.getParameterTypes().length);
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        ReflectionUtils.invokeMethod(method, bean2, this.parseJsonValue((String)propertyValue, types[0]));
        method.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeHolder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, placeHolder, bean2, beanName, method, true);
                this.springValueRegistry.register(this.configurableBeanFactory, key, springValue);
                logger.debug("Monitoring {}", (Object)springValue);
            }
        }
    }

    @Nullable
    private Object resolvePropertyValue(String beanName, String placeHolder) {
        Object propertyValue = this.placeholderHelper.resolvePropertyValue(this.configurableBeanFactory, beanName, placeHolder);
        if (!(propertyValue instanceof String)) {
            return null;
        }
        return propertyValue;
    }

    private Object parseJsonValue(String json, Type targetType) {
        try {
            return GSON.fromJson(json, targetType);
        }
        catch (Throwable ex) {
            logger.error("Parsing json '{}' to type {} failed!", json, targetType, ex);
            throw ex;
        }
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }
}

