/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.PropertiesCompatibleConfigFile;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.PlainTextConfigFile;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.ctrip.framework.apollo.util.yaml.YamlParser;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlConfigFile
extends PlainTextConfigFile
implements PropertiesCompatibleConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigFile.class);
    private volatile Properties cachedProperties;

    public YamlConfigFile(String namespace, ConfigRepository configRepository) {
        super(namespace, configRepository);
        this.tryTransformToProperties();
    }

    @Override
    public ConfigFileFormat getConfigFileFormat() {
        return ConfigFileFormat.YAML;
    }

    @Override
    protected void update(Properties newProperties) {
        super.update(newProperties);
        this.tryTransformToProperties();
    }

    @Override
    public Properties asProperties() {
        if (this.cachedProperties == null) {
            this.transformToProperties();
        }
        return this.cachedProperties;
    }

    private boolean tryTransformToProperties() {
        try {
            this.transformToProperties();
            return true;
        }
        catch (Throwable ex) {
            Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
            logger.warn("yaml to properties failed, reason: {}", (Object)ExceptionUtil.getDetailMessage(ex));
            return false;
        }
    }

    private synchronized void transformToProperties() {
        this.cachedProperties = this.toProperties();
    }

    private Properties toProperties() {
        if (!this.hasContent()) {
            return this.propertiesFactory.getPropertiesInstance();
        }
        try {
            return ApolloInjector.getInstance(YamlParser.class).yamlToProperties(this.getContent());
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Parse yaml file content failed for namespace: " + this.m_namespace, ex);
            Tracer.logError(exception);
            throw exception;
        }
    }
}

