/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.sync.data.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.apollo.ApolloDataService;
import org.apache.shenyu.sync.data.apollo.config.ApolloConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ApolloSyncDataConfiguration.class})
@ConditionalOnProperty(prefix="shenyu.sync.apollo", name={"meta"})
public class ApolloSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApolloSyncDataConfiguration.class);
    private static final String APOLLO_CLUSTER = "apollo.cluster";
    private static final String PROP_APP_ID = "app.id";
    private static final String PROP_APOLLO_META = "apollo.meta";
    private static final String PROP_APOLLO_SECRET = "apollo.access-key";
    private static final String APOLLO_NAMESPACE = "apollo.bootstrap.namespace";

    @Bean
    public ApolloDataService apolloSyncDataService(ObjectProvider<Config> configService, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorDataSubscriber, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamDataSubscribers, ObjectProvider<ShenyuConfig> shenyuConfig) {
        LOGGER.info("you use apollo sync shenyu data.......");
        return new ApolloDataService(configService.getIfAvailable(), pluginSubscriber.getIfAvailable(), (List<MetaDataSubscriber>)metaSubscribers.getIfAvailable(Collections::emptyList), (List<AuthDataSubscriber>)authSubscribers.getIfAvailable(Collections::emptyList), (List<ProxySelectorDataSubscriber>)proxySelectorDataSubscriber.getIfAvailable(Collections::emptyList), discoveryUpstreamDataSubscribers.getIfAvailable(), shenyuConfig.getIfAvailable());
    }

    @Bean
    public Config apolloConfigService(ApolloConfig apolloConfig) {
        Optional.ofNullable(apolloConfig.getAppId()).ifPresent(appId -> System.setProperty(PROP_APP_ID, appId));
        Optional.ofNullable(apolloConfig.getMeta()).ifPresent(meta -> System.setProperty(PROP_APOLLO_META, meta));
        Optional.ofNullable(apolloConfig.getClusterName()).ifPresent(cluster -> System.setProperty(APOLLO_CLUSTER, cluster));
        Optional.ofNullable(apolloConfig.getNamespace()).ifPresent(namespace -> System.setProperty(APOLLO_NAMESPACE, namespace));
        Optional.ofNullable(apolloConfig.getAccessKey()).ifPresent(accessKey -> System.setProperty(PROP_APOLLO_SECRET, accessKey));
        return ConfigService.getAppConfig();
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.apollo")
    public ApolloConfig apolloConfig() {
        return new ApolloConfig();
    }
}

