/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.property;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinition;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class SpringValueDefinitionProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Map<BeanDefinitionRegistry, Multimap<String, SpringValueDefinition>> beanName2SpringValueDefinitions = Maps.newConcurrentMap();
    private static final Set<BeanDefinitionRegistry> PROPERTY_VALUES_PROCESSED_BEAN_FACTORIES = Sets.newConcurrentHashSet();
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            this.processPropertyValues(registry);
        }
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public static Multimap<String, SpringValueDefinition> getBeanName2SpringValueDefinitions(BeanDefinitionRegistry registry) {
        Multimap springValueDefinitions = beanName2SpringValueDefinitions.computeIfAbsent(registry, k -> LinkedListMultimap.create());
        return springValueDefinitions;
    }

    private void processPropertyValues(BeanDefinitionRegistry beanRegistry) {
        String[] beanNames;
        if (!PROPERTY_VALUES_PROCESSED_BEAN_FACTORIES.add(beanRegistry)) {
            return;
        }
        if (!beanName2SpringValueDefinitions.containsKey(beanRegistry)) {
            beanName2SpringValueDefinitions.put(beanRegistry, LinkedListMultimap.create());
        }
        Multimap<String, SpringValueDefinition> springValueDefinitions = beanName2SpringValueDefinitions.get(beanRegistry);
        for (String beanName : beanNames = beanRegistry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanRegistry.getBeanDefinition(beanName);
            MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
            List<PropertyValue> propertyValues = mutablePropertyValues.getPropertyValueList();
            for (PropertyValue propertyValue : propertyValues) {
                String placeholder;
                Set<String> keys;
                Object value = propertyValue.getValue();
                if (!(value instanceof TypedStringValue) || (keys = this.placeholderHelper.extractPlaceholderKeys(placeholder = ((TypedStringValue)value).getValue())).isEmpty()) continue;
                for (String key : keys) {
                    springValueDefinitions.put(beanName, new SpringValueDefinition(key, placeholder, propertyValue.getName()));
                }
            }
        }
    }
}

