/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.boot;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.DeferredLogger;
import com.ctrip.framework.apollo.spring.config.CachedCompositePropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.PropertySourcesUtil;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;

public class ApolloApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = 0;
    private static final Logger logger = LoggerFactory.getLogger(ApolloApplicationContextInitializer.class);
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on(",").omitEmptyStrings().trimResults();
    public static final String[] APOLLO_SYSTEM_PROPERTIES = new String[]{"app.id", "apollo.label", "apollo.cluster", "apollo.cache-dir", "apollo.access-key.secret", "apollo.meta", "apollo.config-service", "apollo.property.order.enable", "apollo.property.names.cache.enable", "apollo.override-system-properties"};
    private final ConfigPropertySourceFactory configPropertySourceFactory = SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    private int order = 0;

    @Override
    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment2 = context.getEnvironment();
        if (!environment2.getProperty("apollo.bootstrap.enabled", Boolean.class, false).booleanValue()) {
            logger.debug("Apollo bootstrap config is not enabled for context {}, see property: ${{}}", (Object)context, (Object)"apollo.bootstrap.enabled");
            return;
        }
        logger.debug("Apollo bootstrap config is enabled for context {}", (Object)context);
        this.initialize(environment2);
    }

    @Override
    protected void initialize(ConfigurableEnvironment environment2) {
        ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        if (environment2.getPropertySources().contains("ApolloBootstrapPropertySources")) {
            DeferredLogger.replayTo();
            if (configUtil.isOverrideSystemProperties()) {
                PropertySourcesUtil.ensureBootstrapPropertyPrecedence(environment2);
            }
            return;
        }
        String namespaces = environment2.getProperty("apollo.bootstrap.namespaces", "application");
        logger.debug("Apollo bootstrap namespaces: {}", (Object)namespaces);
        List<String> namespaceList = NAMESPACE_SPLITTER.splitToList(namespaces);
        CompositePropertySource composite = configUtil.isPropertyNamesCacheEnabled() ? new CachedCompositePropertySource("ApolloBootstrapPropertySources") : new CompositePropertySource("ApolloBootstrapPropertySources");
        for (String namespace : namespaceList) {
            Config config = ConfigService.getConfig(namespace);
            composite.addPropertySource(this.configPropertySourceFactory.getConfigPropertySource(namespace, config));
        }
        if (!configUtil.isOverrideSystemProperties() && environment2.getPropertySources().contains("systemEnvironment")) {
            environment2.getPropertySources().addAfter("systemEnvironment", composite);
            return;
        }
        environment2.getPropertySources().addFirst(composite);
    }

    void initializeSystemProperty(ConfigurableEnvironment environment2) {
        for (String propertyName : APOLLO_SYSTEM_PROPERTIES) {
            this.fillSystemPropertyFromEnvironment(environment2, propertyName);
        }
    }

    private void fillSystemPropertyFromEnvironment(ConfigurableEnvironment environment2, String propertyName) {
        if (System.getProperty(propertyName) != null) {
            return;
        }
        String propertyValue = environment2.getProperty(propertyName);
        if (Strings.isNullOrEmpty(propertyValue)) {
            return;
        }
        System.setProperty(propertyName, propertyValue);
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        this.initializeSystemProperty(configurableEnvironment);
        Boolean eagerLoadEnabled = configurableEnvironment.getProperty("apollo.bootstrap.eagerLoad.enabled", Boolean.class, false);
        if (!eagerLoadEnabled.booleanValue()) {
            return;
        }
        Boolean bootstrapEnabled = configurableEnvironment.getProperty("apollo.bootstrap.enabled", Boolean.class, false);
        if (bootstrapEnabled.booleanValue()) {
            DeferredLogger.enable();
            this.initialize(configurableEnvironment);
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

