/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.internals;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.spi.MetaServerProvider;
import com.ctrip.framework.apollo.core.utils.ResourceUtils;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LegacyMetaServerProvider
implements MetaServerProvider {
    public static final int ORDER = 0x7FFFFFFE;
    private static final Map<Env, String> domains = new HashMap<Env, String>();

    public LegacyMetaServerProvider() {
        this.initialize();
    }

    private void initialize() {
        Properties prop = new Properties();
        prop = ResourceUtils.readConfigFile("apollo-env.properties", prop);
        domains.put(Env.LOCAL, this.getMetaServerAddress(prop, "local_meta", "local.meta"));
        domains.put(Env.DEV, this.getMetaServerAddress(prop, "dev_meta", "dev.meta"));
        domains.put(Env.FAT, this.getMetaServerAddress(prop, "fat_meta", "fat.meta"));
        domains.put(Env.UAT, this.getMetaServerAddress(prop, "uat_meta", "uat.meta"));
        domains.put(Env.LPT, this.getMetaServerAddress(prop, "lpt_meta", "lpt.meta"));
        domains.put(Env.PRO, this.getMetaServerAddress(prop, "pro_meta", "pro.meta"));
    }

    private String getMetaServerAddress(Properties prop, String sourceName, String propName) {
        String metaAddress = System.getProperty(sourceName);
        if (Strings.isNullOrEmpty(metaAddress)) {
            metaAddress = System.getenv(sourceName.toUpperCase());
        }
        if (Strings.isNullOrEmpty(metaAddress)) {
            metaAddress = prop.getProperty(propName);
        }
        return metaAddress;
    }

    @Override
    public String getMetaServerAddress(Env targetEnv) {
        String metaServerAddress = domains.get((Object)targetEnv);
        return metaServerAddress == null ? null : metaServerAddress.trim();
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

