/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.core.utils.DeprecatedPropertyNotifyUtil;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.ctrip.framework.apollo.util.http.HttpClient;
import com.ctrip.framework.apollo.util.http.HttpRequest;
import com.ctrip.framework.apollo.util.http.HttpResponse;
import com.ctrip.framework.foundation.Foundation;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class ConfigServiceLocator {
    private static final Logger logger = DeferredLoggerFactory.getLogger(ConfigServiceLocator.class);
    private HttpClient m_httpClient;
    private ConfigUtil m_configUtil;
    private AtomicReference<List<ServiceDTO>> m_configServices;
    private Type m_responseType;
    private ScheduledExecutorService m_executorService;
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on("&").withKeyValueSeparator("=");
    private static final Escaper queryParamEscaper = UrlEscapers.urlFormParameterEscaper();

    public ConfigServiceLocator() {
        ArrayList initial = Lists.newArrayList();
        this.m_configServices = new AtomicReference(initial);
        this.m_responseType = new TypeToken<List<ServiceDTO>>(){}.getType();
        this.m_httpClient = ApolloInjector.getInstance(HttpClient.class);
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.m_executorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create("ConfigServiceLocator", true));
        this.initConfigServices();
    }

    private void initConfigServices() {
        List<ServiceDTO> customizedConfigServices = this.getCustomizedConfigService();
        if (customizedConfigServices != null) {
            this.setConfigServices(customizedConfigServices);
            return;
        }
        this.tryUpdateConfigServices();
        this.schedulePeriodicRefresh();
    }

    private List<ServiceDTO> getCustomizedConfigService() {
        String configServices = System.getProperty("apollo.config-service");
        if (Strings.isNullOrEmpty(configServices)) {
            configServices = System.getenv("APOLLO_CONFIG_SERVICE");
        }
        if (Strings.isNullOrEmpty(configServices)) {
            configServices = Foundation.server().getProperty("apollo.config-service", null);
        }
        if (Strings.isNullOrEmpty(configServices)) {
            configServices = this.getDeprecatedCustomizedConfigService();
        }
        if (Strings.isNullOrEmpty(configServices)) {
            return null;
        }
        logger.info("Located config services from apollo.config-service configuration: {}, will not refresh config services from remote meta service!", (Object)configServices);
        String[] configServiceUrls = configServices.split(",");
        ArrayList<ServiceDTO> serviceDTOS = Lists.newArrayList();
        for (String configServiceUrl : configServiceUrls) {
            configServiceUrl = configServiceUrl.trim();
            ServiceDTO serviceDTO = new ServiceDTO();
            serviceDTO.setHomepageUrl(configServiceUrl);
            serviceDTO.setAppName("apollo-configservice");
            serviceDTO.setInstanceId(configServiceUrl);
            serviceDTOS.add(serviceDTO);
        }
        return serviceDTOS;
    }

    private String getDeprecatedCustomizedConfigService() {
        String configServices = System.getProperty("apollo.configService");
        if (!Strings.isNullOrEmpty(configServices)) {
            DeprecatedPropertyNotifyUtil.warn("apollo.configService", "apollo.config-service");
        }
        if (Strings.isNullOrEmpty(configServices) && !Strings.isNullOrEmpty(configServices = System.getenv("APOLLO_CONFIGSERVICE"))) {
            DeprecatedPropertyNotifyUtil.warn("APOLLO_CONFIGSERVICE", "APOLLO_CONFIG_SERVICE");
        }
        if (Strings.isNullOrEmpty(configServices) && !Strings.isNullOrEmpty(configServices = Foundation.server().getProperty("apollo.configService", null))) {
            DeprecatedPropertyNotifyUtil.warn("apollo.configService", "apollo.config-service");
        }
        return configServices;
    }

    public List<ServiceDTO> getConfigServices() {
        if (this.m_configServices.get().isEmpty()) {
            this.updateConfigServices();
        }
        return this.m_configServices.get();
    }

    private boolean tryUpdateConfigServices() {
        try {
            this.updateConfigServices();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void schedulePeriodicRefresh() {
        this.m_executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                logger.debug("refresh config services");
                Tracer.logEvent("Apollo.MetaService", "periodicRefresh");
                ConfigServiceLocator.this.tryUpdateConfigServices();
            }
        }, this.m_configUtil.getRefreshInterval(), this.m_configUtil.getRefreshInterval(), this.m_configUtil.getRefreshIntervalTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateConfigServices() {
        String url = this.assembleMetaServiceUrl();
        HttpRequest request = new HttpRequest(url);
        int maxRetries = 2;
        Throwable exception = null;
        for (int i = 0; i < maxRetries; ++i) {
            Transaction transaction = Tracer.newTransaction("Apollo.MetaService", "getConfigService");
            transaction.addData("Url", url);
            try {
                HttpResponse response = this.m_httpClient.doGet(request, this.m_responseType);
                transaction.setStatus("0");
                List services = (List)response.getBody();
                if (services != null && !services.isEmpty()) {
                    this.setConfigServices(services);
                    return;
                }
                this.logConfigService("Empty response!");
                continue;
            }
            catch (Throwable ex) {
                Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
                transaction.setStatus(ex);
                exception = ex;
            }
            finally {
                transaction.complete();
            }
            try {
                this.m_configUtil.getOnErrorRetryIntervalTimeUnit().sleep(this.m_configUtil.getOnErrorRetryInterval());
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new ApolloConfigException(String.format("Get config services failed from %s", url), exception);
    }

    private void setConfigServices(List<ServiceDTO> services) {
        this.m_configServices.set(services);
        this.logConfigServices(services);
    }

    private String assembleMetaServiceUrl() {
        String domainName = this.m_configUtil.getMetaServerDomainName();
        String appId = this.m_configUtil.getAppId();
        String localIp = this.m_configUtil.getLocalIp();
        HashMap<String, String> queryParams = Maps.newHashMap();
        queryParams.put("appId", queryParamEscaper.escape(appId));
        if (!Strings.isNullOrEmpty(localIp)) {
            queryParams.put("ip", queryParamEscaper.escape(localIp));
        }
        return domainName + "/services/config?" + MAP_JOINER.join(queryParams);
    }

    private void logConfigServices(List<ServiceDTO> serviceDtos) {
        for (ServiceDTO serviceDto : serviceDtos) {
            this.logConfigService(serviceDto.getHomepageUrl());
        }
    }

    private void logConfigService(String serviceUrl) {
        Tracer.logEvent("Apollo.Config.Services", serviceUrl);
    }
}

