/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.client.spring.websocket;

import java.util.Objects;
import java.util.Properties;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.ClientRegisterConfigImpl;
import org.apache.shenyu.client.spring.websocket.init.SpringWebSocketClientEventListener;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.VersionUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.springboot.starter.client.common.config.ShenyuClientCommonBeanConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ImportAutoConfiguration(value={ShenyuClientCommonBeanConfiguration.class})
@ConditionalOnProperty(value={"shenyu.register.enabled"}, matchIfMissing=true, havingValue="true")
public class ShenyuSpringWebSocketClientConfiguration {
    @Bean
    public SpringWebSocketClientEventListener springWebSocketClientEventListener(ShenyuClientConfig clientConfig, Environment env, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        ShenyuClientConfig.ClientPropertiesConfig clientPropertiesConfig = (ShenyuClientConfig.ClientPropertiesConfig)clientConfig.getClient().get(RpcTypeEnum.WEB_SOCKET.getName());
        Properties props = Objects.isNull(clientPropertiesConfig) ? null : clientPropertiesConfig.getProps();
        String discoveryMode = env.getProperty("shenyu.discovery.type", "local");
        if (Objects.nonNull(props)) {
            props.setProperty("discoveryLocalMode", Boolean.valueOf("local".equals(discoveryMode)).toString());
        }
        return new SpringWebSocketClientEventListener(clientConfig, shenyuClientRegisterRepository);
    }

    @Bean(value={"webSocketClientRegisterConfig"})
    public ClientRegisterConfig clientRegisterConfig(ShenyuClientConfig shenyuClientConfig, ApplicationContext applicationContext, Environment env) {
        return new ClientRegisterConfigImpl(shenyuClientConfig, RpcTypeEnum.WEB_SOCKET, applicationContext, env);
    }

    static {
        VersionUtils.checkDuplicate(ShenyuSpringWebSocketClientConfiguration.class);
    }
}

