/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.wasm.api;

import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.wasm.api.loader.WasmLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractWasmPlugin
extends WasmLoader
implements ShenyuPlugin {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWasmPlugin.class);
    protected static final Map<Long, Argument> ARGUMENTS = new ConcurrentHashMap<Long, Argument>();
    protected static final String EXECUTE_METHOD_NAME = "execute";
    protected static final String BEFORE_METHOD_NAME = "before";
    protected static final String AFTER_METHOD_NAME = "after";

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return super.getWasmExtern(EXECUTE_METHOD_NAME).map(execute -> {
            Long argumentId = this.callWASI(exchange, chain, (Extern)execute);
            return this.doExecute(exchange, chain, argumentId);
        }).orElseGet(() -> {
            LOG.error("{} function not found in {}", (Object)EXECUTE_METHOD_NAME, (Object)super.getWasmName());
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.WASM_FUNC_NOT_FOUND);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        });
    }

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, ShenyuPluginChain var2, Long var3);

    private Long callWASI(ServerWebExchange exchange, ShenyuPluginChain chain, Extern execute) {
        Long argumentId = this.getArgumentId(exchange, chain);
        ARGUMENTS.put(argumentId, new Argument(exchange, chain));
        WasmFunctions.consumer(super.getStore(), (Func)execute.func(), (WasmValType)WasmValType.I64).accept((Object)argumentId);
        ARGUMENTS.remove(argumentId);
        return argumentId;
    }

    protected abstract Long getArgumentId(ServerWebExchange var1, ShenyuPluginChain var2);

    public void before(ServerWebExchange exchange) {
        super.getWasmExtern(BEFORE_METHOD_NAME).ifPresent(before -> this.callWASI(exchange, null, (Extern)before));
    }

    public void after(ServerWebExchange exchange) {
        super.getWasmExtern(AFTER_METHOD_NAME).ifPresent(before -> this.callWASI(exchange, null, (Extern)before));
    }

    protected static final class Argument {
        private final ServerWebExchange exchange;
        private final ShenyuPluginChain chain;

        private Argument(ServerWebExchange exchange, ShenyuPluginChain chain) {
            this.exchange = exchange;
            this.chain = chain;
        }

        public ServerWebExchange getExchange() {
            return this.exchange;
        }

        public ShenyuPluginChain getChain() {
            return this.chain;
        }
    }
}

