/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient.config;

import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.springframework.util.ResourceUtils;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class HttpClientProperties {
    private String strategy;
    private Integer connectTimeout = 45000;
    private Long responseTimeout = 3000L;
    private Integer readerIdleTime = 3000;
    private Integer writerIdleTime = 3000;
    private Integer allIdleTime = 3000;
    private Integer readTimeout = 3000;
    private Integer writeTimeout = 3000;
    private Pool pool = new Pool();
    private ThreadPool threadPool = new ThreadPool();
    private Proxy proxy = new Proxy();
    private Ssl ssl = new Ssl();
    private boolean wiretap;
    private boolean keepAlive;
    private Integer maxInMemorySize = 1;

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getResponseTimeout() {
        return Optional.ofNullable(this.responseTimeout).map(it -> Duration.ofMillis(this.responseTimeout)).orElse(Duration.ofMillis(3000L));
    }

    public void setResponseTimeout(Long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public Integer getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public void setReaderIdleTime(Integer readerIdleTime) {
        this.readerIdleTime = readerIdleTime;
    }

    public Integer getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public void setWriterIdleTime(Integer writerIdleTime) {
        this.writerIdleTime = writerIdleTime;
    }

    public Integer getAllIdleTime() {
        return this.allIdleTime;
    }

    public void setAllIdleTime(Integer allIdleTime) {
        this.allIdleTime = allIdleTime;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(Integer writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public boolean isWiretap() {
        return this.wiretap;
    }

    public void setWiretap(boolean wiretap) {
        this.wiretap = wiretap;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public void setMaxInMemorySize(Integer maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public static class Pool {
        private PoolType type = PoolType.ELASTIC;
        private String name = "shenyu-proxy";
        private Integer maxConnections = ConnectionProvider.DEFAULT_POOL_MAX_CONNECTIONS;
        private Long acquireTimeout = ConnectionProvider.DEFAULT_POOL_ACQUIRE_TIMEOUT;
        private Long maxIdleTime;
        private Long maxLifeTime;
        private Long evictionInterval;
        private Boolean metrics = Boolean.FALSE;

        public PoolType getType() {
            return this.type;
        }

        public void setType(PoolType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public Long getAcquireTimeout() {
            return this.acquireTimeout;
        }

        public void setAcquireTimeout(Long acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
        }

        public Long getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(Long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public void setMaxLifeTime(Long maxLifeTime) {
            this.maxLifeTime = maxLifeTime;
        }

        public Long getMaxLifeTime() {
            return this.maxLifeTime;
        }

        public Long getEvictionInterval() {
            return this.evictionInterval;
        }

        public void setEvictionInterval(Long evictionInterval) {
            this.evictionInterval = evictionInterval;
        }

        public void setMetrics(Boolean metrics) {
            this.metrics = metrics;
        }

        public Boolean getMetrics() {
            return this.metrics;
        }

        public static enum PoolType {
            ELASTIC,
            FIXED,
            DISABLED;

        }
    }

    public static class ThreadPool {
        private String prefix = "shenyu";
        private Integer selectCount = Integer.parseInt(System.getProperty("reactor.netty.ioSelectCount", "1"));
        private Integer workerCount = LoopResources.DEFAULT_IO_WORKER_COUNT;
        private Boolean daemon = true;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Integer getSelectCount() {
            return this.selectCount;
        }

        public void setSelectCount(Integer selectCount) {
            this.selectCount = selectCount;
        }

        public Integer getWorkerCount() {
            return this.workerCount;
        }

        public void setWorkerCount(Integer workerCount) {
            this.workerCount = workerCount;
        }

        public Boolean getDaemon() {
            return this.daemon;
        }

        public void setDaemon(Boolean daemon) {
            this.daemon = daemon;
        }
    }

    public static class Proxy {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String nonProxyHostsPattern;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getNonProxyHostsPattern() {
            return this.nonProxyHostsPattern;
        }

        public void setNonProxyHostsPattern(String nonProxyHostsPattern) {
            this.nonProxyHostsPattern = nonProxyHostsPattern;
        }
    }

    public class Ssl {
        private boolean useInsecureTrustManager = Boolean.FALSE;
        private List<String> trustedX509Certificates = new ArrayList<String>();
        private Duration handshakeTimeout = Duration.ofMillis(10000L);
        private Duration closeNotifyFlushTimeout = Duration.ofMillis(3000L);
        private Duration closeNotifyReadTimeout = Duration.ZERO;
        private String keyStorePath;
        private String keyStoreType = "PKCS12";
        private String keyStoreProvider;
        private String keyStorePassword;
        private String keyPassword;
        private SslProvider defaultConfigurationType;

        public boolean isUseInsecureTrustManager() {
            return this.useInsecureTrustManager;
        }

        public void setUseInsecureTrustManager(boolean useInsecureTrustManager) {
            this.useInsecureTrustManager = useInsecureTrustManager;
        }

        public List<String> getTrustedX509Certificates() {
            return this.trustedX509Certificates;
        }

        public void setTrustedX509Certificates(List<String> trustedX509Certificates) {
            this.trustedX509Certificates = trustedX509Certificates;
        }

        public Duration getHandshakeTimeout() {
            return this.handshakeTimeout;
        }

        public void setHandshakeTimeout(Duration handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
        }

        public Duration getCloseNotifyFlushTimeout() {
            return this.closeNotifyFlushTimeout;
        }

        public void setCloseNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            this.closeNotifyFlushTimeout = closeNotifyFlushTimeout;
        }

        public Duration getCloseNotifyReadTimeout() {
            return this.closeNotifyReadTimeout;
        }

        public void setCloseNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            this.closeNotifyReadTimeout = closeNotifyReadTimeout;
        }

        public SslProvider getDefaultConfigurationType() {
            return this.defaultConfigurationType;
        }

        public void setDefaultConfigurationType(SslProvider defaultConfigurationType) {
            this.defaultConfigurationType = defaultConfigurationType;
        }

        public String getKeyStorePath() {
            return this.keyStorePath;
        }

        public void setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public String getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public void setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = keyStoreProvider;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public X509Certificate[] getTrustedX509CertificatesForTrustManager() {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<? extends Certificate> allCerts = new ArrayList<Certificate>();
                for (String trustedCert : HttpClientProperties.this.ssl.getTrustedX509Certificates()) {
                    try {
                        URL url = ResourceUtils.getURL((String)trustedCert);
                        Collection<? extends Certificate> certs = certificateFactory.generateCertificates(url.openStream());
                        allCerts.addAll(certs);
                    }
                    catch (IOException e) {
                        throw new ShenyuException("Could not load certificate '" + trustedCert + "'", (Throwable)e);
                    }
                }
                return allCerts.toArray(new X509Certificate[allCerts.size()]);
            }
            catch (CertificateException e) {
                throw new ShenyuException("Could not load CertificateFactory X.509", (Throwable)e);
            }
        }

        public KeyManagerFactory getKeyManagerFactory() {
            try {
                if (StringUtils.isNotEmpty((CharSequence)this.getKeyStorePath())) {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    char[] keyPassword = Optional.ofNullable(this.getKeyPassword()).map(String::toCharArray).orElse(this.getKeyStorePassword().toCharArray());
                    keyManagerFactory.init(this.createKeyStore(), keyPassword);
                    return keyManagerFactory;
                }
                return null;
            }
            catch (Exception e) {
                throw new ShenyuException((Throwable)e);
            }
        }

        public KeyStore createKeyStore() {
            String provider = this.getKeyStoreProvider();
            String storeType = this.getKeyStoreType();
            String keyStorePath = this.getKeyStorePath();
            String keyStorePassword = this.getKeyStorePassword();
            try {
                KeyStore keyStore = StringUtils.isNotEmpty((CharSequence)provider) ? KeyStore.getInstance(storeType, provider) : KeyStore.getInstance(storeType);
                try {
                    char[] keyPassword = Optional.ofNullable(keyStorePassword).map(String::toCharArray).orElse(null);
                    URL url = ResourceUtils.getURL((String)keyStorePath);
                    keyStore.load(url.openStream(), keyPassword);
                }
                catch (Exception e) {
                    throw new ShenyuException("Could not load key store path ' " + keyStorePath + "'", (Throwable)e);
                }
                return keyStore;
            }
            catch (KeyStoreException | NoSuchProviderException e) {
                throw new ShenyuException("Could not load KeyStore for type and provider", (Throwable)e);
            }
        }
    }
}

