/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.alert;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.AlarmContent;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.base.alert.AlarmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AlarmServiceImpl
implements AlarmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmServiceImpl.class);
    private static final String PATH = "/alert/report";
    private final RestTemplate restTemplate;
    private final List<String> adminReportUrls;
    private final boolean enabled;

    public AlarmServiceImpl(RestTemplate restTemplate, String admins, boolean enabled) {
        this.enabled = enabled;
        this.restTemplate = restTemplate;
        this.adminReportUrls = new LinkedList<String>();
        String scheme = System.getProperty("scheme", "http");
        String[] urls = StringUtils.split((String)admins, (String)",");
        if (urls != null) {
            for (int index = 0; index < urls.length; ++index) {
                urls[index] = UriUtils.appendScheme((String)urls[index], (String)scheme);
                urls[index] = urls[index] + PATH;
            }
            this.adminReportUrls.addAll(Arrays.asList(urls));
        }
    }

    @Override
    public void alarm(AlarmContent content) {
        if (!this.enabled) {
            return;
        }
        if (this.adminReportUrls.isEmpty()) {
            LOGGER.error("Please config shenyu.alert.admins alarm reportUrl");
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)content, (MultiValueMap)headers);
        boolean success = false;
        Object errorMsg = "";
        for (String reportUrl : this.adminReportUrls) {
            if (success) continue;
            try {
                ResponseEntity response = this.restTemplate.postForEntity(reportUrl, (Object)request, Void.class, new Object[0]);
                if (response.getStatusCode() == HttpStatus.OK) {
                    success = true;
                    LOGGER.debug("send alarm content success: {}.", (Object)content);
                    continue;
                }
                LOGGER.debug("send alarm content failed: {}.", (Object)response.getStatusCode());
            }
            catch (Exception e) {
                errorMsg = "send alarm content failed: " + e.getMessage();
            }
        }
        if (!success) {
            LOGGER.error((String)errorMsg);
        }
    }
}

