/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.trie;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.RuleTrieEventEnum;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.event.RuleTrieEvent;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.springframework.context.ApplicationListener;

public class ShenyuTrieRuleListener
implements ApplicationListener<RuleTrieEvent> {
    public void onApplicationEvent(RuleTrieEvent event) {
        RuleTrieEventEnum eventEnum = event.getRuleTrieEvent();
        RuleData ruleData = (RuleData)event.getSource();
        List conditionDataList = ruleData.getConditionDataList();
        List filterConditions = conditionDataList.stream().filter(conditionData -> ParamTypeEnum.URI.getName().equals(conditionData.getParamType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterConditions)) {
            List<String> uriPaths = filterConditions.stream().map(ConditionData::getParamValue).collect(Collectors.toList());
            switch (eventEnum) {
                case INSERT: {
                    uriPaths.forEach(path -> ((ShenyuTrie)SpringBeanUtils.getInstance().getBean(ShenyuTrie.class)).putNode((String)path, ruleData, null));
                    break;
                }
                case REMOVE: {
                    uriPaths.forEach(path -> ((ShenyuTrie)SpringBeanUtils.getInstance().getBean(ShenyuTrie.class)).remove((String)path, ruleData.getSelectorId(), ruleData.getId()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + event.getRuleTrieEvent());
                }
            }
        }
    }
}

