/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.trie;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.TrieMatchModeEvent;
import org.apache.shenyu.plugin.base.trie.ShenyuTrieNode;

public class ShenyuTrie {
    private static final String WILDCARD = "*";
    private static final String MATCH_ALL = "**";
    private final ShenyuTrieNode root;
    private final Long childrenSize;
    private final Long pathRuleCacheSize;
    private final Long pathVariableSize;
    private final Object lock = new Object();
    private final String matchMode;

    public ShenyuTrie(Long childrenSize, Long pathRuleCacheSize, Long pathVariableSize, String matchMode) {
        this.root = new ShenyuTrieNode("/", "/", false, childrenSize, pathRuleCacheSize, pathVariableSize);
        this.childrenSize = childrenSize;
        this.pathRuleCacheSize = pathRuleCacheSize;
        this.pathVariableSize = pathVariableSize;
        this.matchMode = matchMode;
    }

    public void clear() {
        ShenyuTrie.cleanup(this.root.getChildren());
        ShenyuTrie.cleanup(this.root.getPathRuleCache());
        ShenyuTrie.cleanup(this.root.getPathVariablesSet());
        this.root.setPathVariableNode(null);
    }

    public boolean isEmpty() {
        return this.root.getChildren().estimatedSize() == 0L && this.root.getPathVariablesSet().estimatedSize() == 0L && Objects.isNull(this.root.getPathVariableNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNode(String uriPath, RuleData ruleData, Object bizInfo) {
        String strippedPath;
        String[] pathParts;
        if (StringUtils.isNotBlank((CharSequence)uriPath) && (pathParts = StringUtils.split((String)(strippedPath = StringUtils.strip((String)uriPath, (String)"/")), (String)"/")).length > 0) {
            List<RuleData> ruleDataList;
            ShenyuTrieNode node = this.root;
            for (int i = 0; i < pathParts.length; ++i) {
                boolean endOfPath = ShenyuTrie.isMatchAllOrWildcard(pathParts[i]) && ShenyuTrie.judgeEqual(i, pathParts.length - 1);
                node = this.putNode0(pathParts[i], node, this.matchMode, endOfPath);
            }
            node.setFullPath(uriPath);
            node.setEndOfPath(true);
            node.setBizInfo(bizInfo);
            if (Objects.isNull(node.getPathRuleCache())) {
                node.setPathRuleCache((Cache<String, List<RuleData>>)Caffeine.newBuilder().maximumSize(this.pathRuleCacheSize.longValue()).build());
            }
            if (CollectionUtils.isNotEmpty(ruleDataList = ShenyuTrie.getVal(node.getPathRuleCache(), ruleData.getSelectorId()))) {
                Object object = this.lock;
                synchronized (object) {
                    ruleDataList.add(ruleData);
                    List collect = ruleDataList.stream().sorted(Comparator.comparing(RuleData::getSort)).collect(Collectors.toList());
                    node.getPathRuleCache().put((Object)ruleData.getSelectorId(), collect);
                }
            } else {
                node.getPathRuleCache().put((Object)ruleData.getSelectorId(), (Object)Lists.newArrayList((Object[])new RuleData[]{ruleData}));
            }
        }
    }

    private ShenyuTrieNode putNode0(String segment, ShenyuTrieNode shenyuTrieNode, String matchMode, boolean isPathEnd) {
        if (TrieMatchModeEvent.PATH_PATTERN.getMatchMode().equals(matchMode)) {
            if (ShenyuTrie.isMatchAll(segment)) {
                return this.put(segment, shenyuTrieNode, true);
            }
            if (ShenyuTrie.isMatchWildcard(segment)) {
                ShenyuTrieNode wildcardNode = this.put(segment, shenyuTrieNode, true);
                wildcardNode.setWildcard(true);
                return wildcardNode;
            }
        }
        if (TrieMatchModeEvent.ANT_PATH_MATCH.getMatchMode().equals(matchMode)) {
            if (ShenyuTrie.isMatchAll(segment) && isPathEnd) {
                return this.put(segment, shenyuTrieNode, true);
            }
            if (ShenyuTrie.isMatchWildcard(segment) && isPathEnd) {
                ShenyuTrieNode wildcardNode = this.put(segment, shenyuTrieNode, true);
                wildcardNode.setWildcard(true);
                return wildcardNode;
            }
        }
        if (segment.startsWith("{") && segment.endsWith("}")) {
            ShenyuTrieNode childNode;
            if (ShenyuTrie.containsKey(shenyuTrieNode.getPathVariablesSet(), segment)) {
                childNode = ShenyuTrie.getVal(shenyuTrieNode.getPathVariablesSet(), segment);
            } else {
                childNode = new ShenyuTrieNode();
                childNode.setMatchStr(segment);
                childNode.setEndOfPath(false);
                if (Objects.isNull(shenyuTrieNode.getPathVariablesSet())) {
                    shenyuTrieNode.setPathVariablesSet((Cache<String, ShenyuTrieNode>)Caffeine.newBuilder().maximumSize(this.pathVariableSize.longValue()).build());
                }
                shenyuTrieNode.getPathVariablesSet().put((Object)segment, (Object)childNode);
                shenyuTrieNode.setPathVariableNode(childNode);
            }
            return childNode;
        }
        return this.put(segment, shenyuTrieNode, false);
    }

    private ShenyuTrieNode put(String segment, ShenyuTrieNode shenyuTrieNode, boolean endOfPath) {
        ShenyuTrieNode childrenNode;
        if (Objects.isNull(shenyuTrieNode.getChildren())) {
            shenyuTrieNode.setChildren((Cache<String, ShenyuTrieNode>)Caffeine.newBuilder().maximumSize(this.childrenSize.longValue()).build());
        }
        if (ShenyuTrie.containsKey(shenyuTrieNode.getChildren(), segment)) {
            childrenNode = ShenyuTrie.getVal(shenyuTrieNode.getChildren(), segment);
        } else {
            childrenNode = new ShenyuTrieNode();
            childrenNode.setMatchStr(segment);
            childrenNode.setEndOfPath(endOfPath);
            shenyuTrieNode.getChildren().put((Object)segment, (Object)childrenNode);
        }
        return childrenNode;
    }

    public ShenyuTrieNode match(String uriPath, String selectorId) {
        String strippedPath;
        String[] pathParts;
        Objects.requireNonNull(selectorId);
        if (!StringUtils.isEmpty((CharSequence)uriPath) && (pathParts = StringUtils.split((String)(strippedPath = StringUtils.strip((String)uriPath, (String)"/")), (String)"/")).length > 0) {
            ShenyuTrieNode currentNode = this.root;
            for (int i = 0; i < pathParts.length; ++i) {
                String path = pathParts[i];
                if (Objects.nonNull(currentNode = this.matchNode(path, currentNode))) {
                    boolean endPath = ShenyuTrie.judgeEqual(i, pathParts.length - 1);
                    if (ShenyuTrie.checkChildrenNotNull(currentNode) && !currentNode.getEndOfPath()) continue;
                    if (endPath && ShenyuTrie.checkPathRuleNotNull(currentNode) && CollectionUtils.isNotEmpty((Collection)ShenyuTrie.getVal(currentNode.getPathRuleCache(), selectorId))) {
                        return currentNode;
                    }
                    if (!ShenyuTrie.isMatchAll(currentNode.getMatchStr()) || !currentNode.getEndOfPath() || !ShenyuTrie.checkPathRuleNotNull(currentNode) || !CollectionUtils.isNotEmpty((Collection)ShenyuTrie.getVal(currentNode.getPathRuleCache(), selectorId))) continue;
                    return currentNode;
                }
                return null;
            }
        }
        return null;
    }

    private ShenyuTrieNode matchNode(String segment, ShenyuTrieNode node) {
        if (Objects.nonNull(node)) {
            if (ShenyuTrie.checkChildrenNotNull(node) && ShenyuTrie.containsKey(node.getChildren(), segment)) {
                return ShenyuTrie.getVal(node.getChildren(), segment);
            }
            if (ShenyuTrie.checkChildrenNotNull(node) && ShenyuTrie.containsKey(node.getChildren(), WILDCARD)) {
                return ShenyuTrie.getVal(node.getChildren(), WILDCARD);
            }
            if (ShenyuTrie.checkChildrenNotNull(node) && ShenyuTrie.containsKey(node.getChildren(), MATCH_ALL)) {
                return ShenyuTrie.getVal(node.getChildren(), MATCH_ALL);
            }
            if (Objects.nonNull(node.getPathVariableNode())) {
                return node.getPathVariableNode();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path, String selectorId, String ruleId) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String strippedPath = StringUtils.strip((String)path, (String)"/");
            String[] pathParts = StringUtils.split((String)strippedPath, (String)"/");
            String key = pathParts[pathParts.length - 1];
            ShenyuTrieNode currentNode = this.getNode(path);
            if (Objects.nonNull(currentNode) && Objects.nonNull(currentNode.getPathRuleCache())) {
                currentNode.getPathRuleCache().cleanUp();
                List<RuleData> ruleDataList = ShenyuTrie.getVal(currentNode.getPathRuleCache(), selectorId);
                if (CollectionUtils.isNotEmpty(ruleDataList) && ruleDataList.size() == 1 && Objects.isNull(currentNode.getChildren())) {
                    CharSequence[] parentPathArray = Arrays.copyOfRange(pathParts, 0, pathParts.length - 1);
                    String parentPath = String.join((CharSequence)"/", parentPathArray);
                    ShenyuTrieNode parentNode = this.getNode(parentPath);
                    parentNode.getChildren().invalidate((Object)key);
                    parentNode.getChildren().cleanUp();
                } else {
                    List<RuleData> delRuleData = ShenyuTrie.getVal(currentNode.getPathRuleCache(), selectorId);
                    if (CollectionUtils.isNotEmpty(delRuleData)) {
                        Object object = this.lock;
                        synchronized (object) {
                            delRuleData.removeIf(rule -> rule.getId().equals(ruleId));
                        }
                    }
                }
            }
        }
    }

    public ShenyuTrieNode getNode(String uriPath) {
        if (StringUtils.isNotBlank((CharSequence)uriPath)) {
            String strippedPath = StringUtils.strip((String)uriPath, (String)"/");
            String[] pathParts = StringUtils.split((String)strippedPath, (String)"/");
            if (pathParts.length > 0) {
                return this.getNode0(this.root, pathParts);
            }
            return null;
        }
        return null;
    }

    private ShenyuTrieNode getNode0(ShenyuTrieNode node, String[] pathParts) {
        String key = pathParts[0];
        String[] slice = Arrays.copyOfRange(pathParts, 1, pathParts.length);
        if (slice.length == 0) {
            if (ShenyuTrie.isPathVariable(key)) {
                if (Objects.isNull(node.getPathVariableNode()) || !node.getPathVariableNode().getEndOfPath()) {
                    return null;
                }
                return node.getPathVariableNode();
            }
            if (ShenyuTrie.isMatchAllOrWildcard(key)) {
                return ShenyuTrie.getVal(node.getChildren(), key);
            }
            if (Objects.isNull(node) || !ShenyuTrie.checkChildrenNotNull(node)) {
                return null;
            }
            return ShenyuTrie.getVal(node.getChildren(), key);
        }
        if (ShenyuTrie.isPathVariable(key)) {
            if (Objects.isNull(node.getPathVariableNode())) {
                return null;
            }
            return this.getNode0(node.getPathVariableNode(), slice);
        }
        if (Objects.isNull(node) || Objects.isNull(node.getChildren()) || Objects.isNull(ShenyuTrie.getVal(node.getChildren(), key))) {
            return null;
        }
        return this.getNode0(ShenyuTrie.getVal(node.getChildren(), key), slice);
    }

    private Object getBizInfo(ShenyuTrieNode trieNode) {
        return trieNode.getBizInfo();
    }

    private static boolean isMatchAll(String key) {
        return MATCH_ALL.equals(key);
    }

    private static boolean isMatchWildcard(String key) {
        return WILDCARD.equals(key);
    }

    private static boolean isMatchAllOrWildcard(String key) {
        return ShenyuTrie.isMatchAll(key) || ShenyuTrie.isMatchWildcard(key);
    }

    private static boolean isPathVariable(String key) {
        return Objects.nonNull(key) && key.startsWith("{") && key.endsWith("}");
    }

    private static <V> boolean containsKey(Cache<String, V> cache, String key) {
        V ret = ShenyuTrie.getVal(cache, key);
        return Objects.nonNull(ret);
    }

    private static <V> V getVal(Cache<String, V> cache, String key) {
        if (Objects.nonNull(cache)) {
            return (V)cache.getIfPresent((Object)key);
        }
        return null;
    }

    private static <V> void cleanup(Cache<String, V> cache) {
        if (Objects.nonNull(cache)) {
            cache.invalidateAll();
            cache.cleanUp();
        }
    }

    private static boolean checkChildrenNotNull(ShenyuTrieNode shenyuTrieNode) {
        return Objects.nonNull(shenyuTrieNode) && Objects.nonNull(shenyuTrieNode.getChildren());
    }

    private static boolean checkPathRuleNotNull(ShenyuTrieNode shenyuTrieNode) {
        return Objects.nonNull(shenyuTrieNode) && Objects.nonNull(shenyuTrieNode.getPathRuleCache());
    }

    private static boolean judgeEqual(int param, int actual) {
        return param == actual;
    }
}

