/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.condition.strategy.MatchStrategyFactory;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.apache.shenyu.plugin.base.trie.ShenyuTrieNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractShenyuPlugin
implements ShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShenyuPlugin.class);
    private static final String URI_CONDITION_TYPE = "uri";
    private ShenyuConfig.MatchCache matchCacheConfig;

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4);

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        List ruleDataList;
        this.initMatchCacheConfig();
        String pluginName = this.named();
        PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(pluginName);
        if (Objects.isNull(pluginData) || !pluginData.getEnabled().booleanValue()) {
            return chain.execute(exchange);
        }
        String path = exchange.getRequest().getURI().getPath();
        List<SelectorData> selectors = BaseDataCache.getInstance().obtainSelectorData(pluginName);
        SelectorData selectorData = this.obtainSelectorDataCacheIfEnabled(path);
        if (Objects.nonNull(selectorData) && StringUtils.isBlank((CharSequence)selectorData.getId())) {
            return this.handleSelectorIfNull(pluginName, exchange, chain);
        }
        if (Objects.isNull(selectorData)) {
            if (CollectionUtils.isEmpty(selectors)) {
                return this.handleSelectorIfNull(pluginName, exchange, chain);
            }
            Pair<Boolean, SelectorData> matchSelectorData = this.matchSelector(exchange, selectors);
            selectorData = (SelectorData)matchSelectorData.getRight();
            if (Objects.isNull(selectorData)) {
                if (this.matchCacheConfig.getSelectorEnabled() && ((Boolean)matchSelectorData.getLeft()).booleanValue()) {
                    selectorData = new SelectorData();
                    selectorData.setPluginName(pluginName);
                    this.cacheSelectorData(path, selectorData);
                }
                return this.handleSelectorIfNull(pluginName, exchange, chain);
            }
            if (this.matchCacheConfig.getSelectorEnabled() && ((Boolean)matchSelectorData.getLeft()).booleanValue()) {
                this.cacheSelectorData(path, selectorData);
            }
        }
        this.printLog(selectorData, pluginName);
        if (Objects.nonNull(selectorData.getContinued()) && !selectorData.getContinued().booleanValue()) {
            return this.doExecute(exchange, chain, selectorData, this.defaultRuleData(selectorData));
        }
        List<RuleData> rules = BaseDataCache.getInstance().obtainRuleData(selectorData.getId());
        if (CollectionUtils.isEmpty(rules)) {
            return this.handleRuleIfNull(pluginName, exchange, chain);
        }
        if (selectorData.getType().intValue() == SelectorTypeEnum.FULL_FLOW.getCode()) {
            RuleData rule = rules.get(rules.size() - 1);
            this.printLog(rule, pluginName);
            return this.doExecute(exchange, chain, selectorData, rule);
        }
        ShenyuTrieNode matchTrieNode = ((ShenyuTrie)SpringBeanUtils.getInstance().getBean(ShenyuTrie.class)).match(path, selectorData.getId());
        RuleData ruleData = Objects.nonNull(matchTrieNode) ? (CollectionUtils.isNotEmpty((Collection)(ruleDataList = (List)matchTrieNode.getPathRuleCache().getIfPresent((Object)selectorData.getId()))) ? this.genericMatchRule(exchange, ruleDataList) : this.genericMatchRule(exchange, rules)) : this.genericMatchRule(exchange, rules);
        if (Objects.isNull(ruleData)) {
            return this.handleRuleIfNull(pluginName, exchange, chain);
        }
        this.printLog(ruleData, pluginName);
        return this.doExecute(exchange, chain, selectorData, ruleData);
    }

    private void initMatchCacheConfig() {
        if (Objects.isNull(this.matchCacheConfig)) {
            this.matchCacheConfig = ((ShenyuConfig)SpringBeanUtils.getInstance().getBean(ShenyuConfig.class)).getMatchCache();
        }
    }

    private void cacheSelectorData(String path, SelectorData selectorData) {
        boolean isUriCondition;
        if (StringUtils.isBlank((CharSequence)selectorData.getId())) {
            MatchDataCache.getInstance().cacheSelectorData(path, selectorData, this.getSelectorMaxFreeMemory());
            return;
        }
        List conditionList = selectorData.getConditionList();
        if (CollectionUtils.isNotEmpty((Collection)conditionList) && (isUriCondition = conditionList.stream().allMatch(v -> URI_CONDITION_TYPE.equals(v.getParamType())))) {
            MatchDataCache.getInstance().cacheSelectorData(path, selectorData, this.getSelectorMaxFreeMemory());
        }
    }

    private Integer getSelectorMaxFreeMemory() {
        return this.matchCacheConfig.getMaxSelectorFreeMemory() * 1024 * 1024;
    }

    private SelectorData obtainSelectorDataCacheIfEnabled(String path) {
        return this.matchCacheConfig.getSelectorEnabled() ? MatchDataCache.getInstance().obtainSelectorData(this.named(), path) : null;
    }

    protected RuleData defaultRuleData(SelectorData selectorData) {
        RuleData ruleData = new RuleData();
        ruleData.setSelectorId(selectorData.getId());
        ruleData.setPluginName(selectorData.getPluginName());
        return ruleData;
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    private Pair<Boolean, SelectorData> matchSelector(ServerWebExchange exchange, Collection<SelectorData> selectors) {
        List<SelectorData> filterCollectors = selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, exchange) != false).distinct().collect(Collectors.toList());
        if (filterCollectors.size() > 1) {
            return Pair.of((Object)Boolean.FALSE, (Object)this.manyMatchSelector(filterCollectors));
        }
        return Pair.of((Object)Boolean.TRUE, (Object)filterCollectors.stream().findFirst().orElse(null));
    }

    private SelectorData manyMatchSelector(List<SelectorData> filterCollectors) {
        Map<Integer, List<Pair>> collect = filterCollectors.stream().map(selector -> {
            boolean match = MatchModeEnum.match((Integer)selector.getMatchMode(), (MatchModeEnum)MatchModeEnum.AND);
            int sort = 0;
            if (match) {
                sort = selector.getConditionList().size();
            }
            return Pair.of((Object)sort, (Object)selector);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        Integer max = Collections.max(collect.keySet());
        List<Pair> pairs = collect.get(max);
        return pairs.stream().map(Pair::getRight).min(Comparator.comparing(SelectorData::getSort)).orElse(null);
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyFactory.match(selector.getMatchMode(), selector.getConditionList(), exchange);
        }
        return true;
    }

    private RuleData genericMatchRule(ServerWebExchange exchange, Collection<RuleData> rules) {
        Pair<Boolean, RuleData> genericMatchRule = this.matchRule(exchange, rules);
        if (((Boolean)genericMatchRule.getLeft()).booleanValue()) {
            return (RuleData)genericMatchRule.getRight();
        }
        return null;
    }

    private Pair<Boolean, RuleData> matchRule(ServerWebExchange exchange, Collection<RuleData> rules) {
        List<RuleData> filterRuleData = rules.stream().filter(rule -> this.filterRule((RuleData)rule, exchange)).distinct().collect(Collectors.toList());
        if (filterRuleData.size() > 1) {
            return Pair.of((Object)Boolean.TRUE, (Object)this.manyMatchRule(filterRuleData));
        }
        return Pair.of((Object)Boolean.TRUE, (Object)filterRuleData.stream().findFirst().orElse(null));
    }

    private RuleData manyMatchRule(List<RuleData> filterRuleData) {
        Map<Integer, List<Pair>> collect = filterRuleData.stream().map(rule -> {
            boolean match = MatchModeEnum.match((Integer)rule.getMatchMode(), (MatchModeEnum)MatchModeEnum.AND);
            int sort = 0;
            if (match) {
                sort = rule.getConditionDataList().size();
            }
            return Pair.of((Object)sort, (Object)rule);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        Integer max = Collections.max(collect.keySet());
        List<Pair> pairs = collect.get(max);
        return pairs.stream().map(Pair::getRight).min(Comparator.comparing(RuleData::getSort)).orElse(null);
    }

    private Boolean filterRule(RuleData ruleData, ServerWebExchange exchange) {
        return ruleData.getEnabled() != false && MatchStrategyFactory.match(ruleData.getMatchMode(), ruleData.getConditionDataList(), exchange);
    }

    private void printLog(Object data, String pluginName) {
        RuleData rule;
        SelectorData selector;
        if (data instanceof SelectorData && (selector = (SelectorData)data).getLogged().booleanValue()) {
            LOG.info("{} selector success match , selector name :{}", (Object)pluginName, (Object)selector.getName());
        }
        if (data instanceof RuleData && (rule = (RuleData)data).getLoged().booleanValue()) {
            LOG.info("{} rule success match , rule name :{}", (Object)pluginName, (Object)rule.getName());
        }
    }
}

