/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;

public class CommonMetaDataSubscriber
implements MetaDataSubscriber {
    private final Map<String, MetaDataHandler> handlerMap;

    public CommonMetaDataSubscriber(List<MetaDataHandler> metaDataHandlerList) {
        this.handlerMap = metaDataHandlerList.stream().collect(Collectors.toConcurrentMap(MetaDataHandler::rpcType, e -> e));
    }

    public void onSubscribe(MetaData metaData) {
        Optional.ofNullable(this.handlerMap.get(metaData.getRpcType())).ifPresent(handler -> handler.handle(metaData));
    }

    public void unSubscribe(MetaData metaData) {
        Optional.ofNullable(this.handlerMap.get(metaData.getRpcType())).ifPresent(handler -> handler.remove(metaData));
    }

    public void refresh() {
        if (MapUtils.isEmpty(this.handlerMap)) {
            return;
        }
        this.handlerMap.forEach((k, v) -> v.refresh());
    }
}

