/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.repository;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.CommonDiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.plugin.base.cache.CommonPluginDataSubscriber;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.global.subsciber.MetaDataCacheSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuCacheRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuCacheRepository.class);
    private final CommonPluginDataSubscriber subscriber;
    private final CommonDiscoveryUpstreamDataSubscriber discoveryUpstreamDataSubscriber;
    private final MetaDataSubscriber metaDataSubscriber;
    private final MetaDataCacheSubscriber metaDataCacheSubscriber;

    public ShenyuCacheRepository(CommonPluginDataSubscriber subscriber, CommonDiscoveryUpstreamDataSubscriber discoveryUpstreamDataSubscriber, MetaDataSubscriber metaDataSubscriber, MetaDataCacheSubscriber metaDataCacheSubscriber) {
        this.subscriber = subscriber;
        this.discoveryUpstreamDataSubscriber = discoveryUpstreamDataSubscriber;
        this.metaDataSubscriber = metaDataSubscriber;
        this.metaDataCacheSubscriber = metaDataCacheSubscriber;
    }

    public PluginData findPluginData(String pluginName) {
        return BaseDataCache.getInstance().obtainPluginData(pluginName);
    }

    public void saveOrUpdatePluginData(PluginData pluginData) {
        this.subscriber.onSubscribe(pluginData);
    }

    public void deletePluginData(String pluginName) {
        this.subscriber.unSubscribe(PluginData.builder().name(pluginName).build());
    }

    public List<SelectorData> findSelectorDataList(String pluginName) {
        return BaseDataCache.getInstance().obtainSelectorData(pluginName);
    }

    public void saveOrUpdateSelectorData(SelectorData selectorData) {
        this.subscriber.onSelectorSubscribe(selectorData);
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setSelectorName(selectorData.getName());
        discoverySyncData.setSelectorId(selectorData.getId());
        discoverySyncData.setPluginName(selectorData.getPluginName());
        discoverySyncData.setUpstreamDataList(this.convert(selectorData.getPluginName(), selectorData.getHandle()));
        this.saveOrUpdateDiscoveryUpstreamData(discoverySyncData);
    }

    private List<DiscoveryUpstreamData> convert(String pluginName, String handle) {
        LOG.info("saveOrUpdateSelectorData convert handle={}", (Object)handle);
        List divideUpstreams = GsonUtils.getInstance().fromList(handle, DivideUpstream.class);
        if (CollectionUtils.isEmpty((Collection)divideUpstreams)) {
            return Collections.emptyList();
        }
        return divideUpstreams.stream().map(up -> {
            DiscoveryUpstreamData upstreamData = new DiscoveryUpstreamData();
            upstreamData.setUrl(up.getUpstreamUrl());
            upstreamData.setProtocol(up.getProtocol());
            upstreamData.setWeight(up.getWeight());
            upstreamData.setStatus(up.isStatus() ? 0 : 1);
            Properties properties = new Properties();
            properties.setProperty("warmup", String.valueOf(up.getWarmup()));
            properties.setProperty("upstreamHost", String.valueOf(up.getUpstreamHost()));
            upstreamData.setDateUpdated(Optional.of(up.getTimestamp()).map(Timestamp::new).orElse(new Timestamp(System.currentTimeMillis())));
            upstreamData.setProps(GsonUtils.getInstance().toJson((Object)properties));
            upstreamData.setDateCreated(Optional.of(up.getTimestamp()).map(Timestamp::new).orElse(new Timestamp(System.currentTimeMillis())));
            return upstreamData;
        }).collect(Collectors.toList());
    }

    public void saveOrUpdateDiscoveryUpstreamData(DiscoverySyncData data) {
        this.discoveryUpstreamDataSubscriber.onSubscribe(data);
    }

    public void deleteSelectorData(String pluginName, String selectorId) {
        this.subscriber.unSelectorSubscribe(SelectorData.builder().pluginName(pluginName).id(selectorId).build());
    }

    public List<RuleData> findRuleDataList(String selectorId) {
        return BaseDataCache.getInstance().obtainRuleData(selectorId);
    }

    public void saveOrUpdateRuleData(RuleData ruleData) {
        this.subscriber.onRuleSubscribe(ruleData);
    }

    public void deleteRuleData(String pluginName, String selectorId, String ruleId) {
        this.subscriber.unRuleSubscribe(RuleData.builder().pluginName(pluginName).selectorId(selectorId).id(ruleId).build());
    }

    public MetaData findMetaData(String path) {
        return MetaDataCache.getInstance().obtain(path);
    }

    public void saveOrUpdateMetaData(MetaData metaData) {
        this.metaDataSubscriber.onSubscribe(metaData);
        this.metaDataCacheSubscriber.onSubscribe(metaData);
    }

    public void deleteMetaData(MetaData metaData) {
        this.metaDataSubscriber.unSubscribe(metaData);
        this.metaDataCacheSubscriber.unSubscribe(metaData);
    }
}

