/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.WebSocketRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.WebSocketUpstream;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.IngressParser;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(IngressParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public WebSocketParser(Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister) {
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec())) {
            V1IngressBackend webSocketBackend = ingress.getSpec().getDefaultBackend();
            List rules = ingress.getSpec().getRules();
            List tlsList = ingress.getSpec().getTls();
            String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
            List<WebSocketUpstream> webSocketUpstreamList = this.parseDefaultWebSocketService(webSocketBackend, namespace);
            if (Objects.isNull(rules) || CollectionUtils.isEmpty((Collection)rules)) {
                if (Objects.nonNull(webSocketBackend) && Objects.nonNull(webSocketBackend.getService())) {
                    IngressConfiguration defaultRouteConfig = this.getDefaultRouteConfig(webSocketUpstreamList, ingress.getMetadata().getAnnotations());
                    res.setGlobalDefaultBackend((Pair<Pair<String, String>, IngressConfiguration>)Pair.of((Object)Pair.of((Object)(namespace + "/" + ingress.getMetadata().getName()), (Object)webSocketBackend.getService().getName()), (Object)defaultRouteConfig));
                }
            } else {
                ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
                for (V1IngressRule ingressRule : rules) {
                    List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, webSocketUpstreamList, Objects.requireNonNull(ingress.getMetadata()).getNamespace(), ingress.getMetadata().getAnnotations());
                    routeList.addAll(routes);
                }
                res.setRouteConfigList(routeList);
            }
            if (Objects.nonNull(tlsList) && CollectionUtils.isNotEmpty((Collection)tlsList)) {
                ArrayList<SslCrtAndKeyStream> sslList = new ArrayList<SslCrtAndKeyStream>();
                for (V1IngressTLS tls : tlsList) {
                    String secretName = tls.getSecretName();
                    List hosts = tls.getHosts();
                    if (!Objects.nonNull(secretName) || !CollectionUtils.isNotEmpty((Collection)hosts)) continue;
                    try {
                        V1Secret secret = coreV1Api.readNamespacedSecret(secretName, namespace, "ture");
                        if (!Objects.nonNull(secret.getData())) continue;
                        ByteArrayInputStream keyCertChainInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.crt"));
                        ByteArrayInputStream keyInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.key"));
                        hosts.forEach(host -> sslList.add(new SslCrtAndKeyStream(host, keyCertChainInputStream, keyInputStream)));
                    }
                    catch (ApiException e) {
                        LOG.error("parse tls failed ", (Throwable)e);
                    }
                }
                res.setTlsConfigList(sslList);
            }
        }
        return res;
    }

    private List<WebSocketUpstream> parseDefaultWebSocketService(V1IngressBackend defaultBackend, String namespace) {
        ArrayList<WebSocketUpstream> webSocketUpstreamList = new ArrayList<WebSocketUpstream>();
        if (Objects.nonNull(defaultBackend) && Objects.nonNull(defaultBackend.getService())) {
            String serviceName = defaultBackend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            V1Service v1Service = (V1Service)this.serviceLister.namespace(namespace).get(serviceName);
            Map annotations = v1Service.getMetadata().getAnnotations();
            String[] protocols = ((String)annotations.get("shenyu.apache.org/upstreams-protocol")).split(",");
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || CollectionUtils.isEmpty((Collection)addresses)) continue;
                    int i = 0;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(defaultBackend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        WebSocketUpstream upstream = WebSocketUpstream.builder().upstreamUrl(upstreamIp + ":" + defaultPort).weight(50).protocol(Objects.isNull(protocols[i++]) ? "ws://" : protocols[i++]).warmup(0).status(true).host("").build();
                        webSocketUpstreamList.add(upstream);
                    }
                }
            }
        }
        return webSocketUpstreamList;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, List<WebSocketUpstream> webSocketUpstream, String namespace, Map<String, String> annotations) {
        List paths;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData hostCondition = null;
        if (Objects.nonNull(ingressRule.getHost())) {
            hostCondition = new ConditionData();
            hostCondition.setParamType(ParamTypeEnum.DOMAIN.getName());
            hostCondition.setOperator(OperatorEnum.EQ.getAlias());
            hostCondition.setParamValue(ingressRule.getHost());
        }
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                OperatorEnum operator;
                String pathPath = path.getPath();
                if (Objects.isNull(pathPath)) continue;
                if ("ImplementationSpecific".equals(path.getPathType())) {
                    operator = OperatorEnum.MATCH;
                } else if ("Prefix".equals(path.getPathType())) {
                    operator = OperatorEnum.STARTS_WITH;
                } else if ("Exact".equals(path.getPathType())) {
                    operator = OperatorEnum.EQ;
                } else {
                    LOG.info("Invalid path type, set it with match operator");
                    operator = OperatorEnum.MATCH;
                }
                ConditionData pathCondition = new ConditionData();
                pathCondition.setOperator(operator.getAlias());
                pathCondition.setParamType(ParamTypeEnum.URI.getName());
                pathCondition.setParamValue(pathPath);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                SelectorData selectorData = SelectorData.builder().pluginId(String.valueOf(PluginEnum.WEB_SOCKET.getCode())).pluginName(PluginEnum.WEB_SOCKET.getName()).name(pathPath).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).build();
                List<WebSocketUpstream> upstreamList = this.parseUpstream(path.getBackend(), namespace);
                if (upstreamList.isEmpty()) {
                    upstreamList = webSocketUpstream;
                }
                selectorData.setHandle(GsonUtils.getInstance().toJson(upstreamList));
                WebSocketRuleHandle webSocketRuleHandle = new WebSocketRuleHandle();
                if (Objects.nonNull(annotations)) {
                    webSocketRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
                    webSocketRuleHandle.setRetry(Integer.parseInt(annotations.getOrDefault("shenyu.apache.org/retry", "0")));
                    webSocketRuleHandle.setTimeout(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/timeout", "3000")));
                }
                RuleData ruleData = RuleData.builder().name(pathPath).pluginName(PluginEnum.WEB_SOCKET.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(conditionList).handle(GsonUtils.getInstance().toJson((Object)webSocketRuleHandle)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).build();
                res.add(new IngressConfiguration(selectorData, Arrays.asList(ruleData), null));
            }
        }
        return res;
    }

    private String parsePort(V1IngressServiceBackend service) {
        V1ServiceBackendPort servicePort = service.getPort();
        if (Objects.nonNull(servicePort)) {
            String trim;
            Integer portNumber = servicePort.getNumber();
            if (Objects.nonNull(portNumber) && portNumber > 0) {
                return String.valueOf(portNumber);
            }
            String servicePortName = servicePort.getName();
            if (Objects.nonNull(servicePortName) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trim = servicePortName.trim()})) {
                return trim;
            }
        }
        return null;
    }

    private List<WebSocketUpstream> parseUpstream(V1IngressBackend backend, String namespace) {
        ArrayList<WebSocketUpstream> upstreamList = new ArrayList<WebSocketUpstream>();
        if (Objects.nonNull(backend) && Objects.nonNull(backend.getService()) && Objects.nonNull(backend.getService().getName())) {
            String serviceName = backend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || addresses.isEmpty()) continue;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(backend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        WebSocketUpstream upstream = WebSocketUpstream.builder().upstreamUrl(upstreamIp + ":" + defaultPort).weight(100).protocol("ws://").warmup(0).status(true).host("").build();
                        upstreamList.add(upstream);
                    }
                }
            }
        }
        return upstreamList;
    }

    private IngressConfiguration getDefaultRouteConfig(List<WebSocketUpstream> divideUpstream, Map<String, String> annotations) {
        ConditionData conditionData = new ConditionData();
        conditionData.setParamName("default");
        conditionData.setParamType(ParamTypeEnum.URI.getName());
        conditionData.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        conditionData.setParamValue("/**");
        SelectorData selectorData = SelectorData.builder().name("default-selector").sort(Integer.valueOf(Integer.MAX_VALUE)).conditionList(Collections.singletonList(conditionData)).handle(GsonUtils.getInstance().toJson(divideUpstream)).enabled(Boolean.valueOf(true)).id("1").pluginName(PluginEnum.WEB_SOCKET.getName()).pluginId(String.valueOf(PluginEnum.WEB_SOCKET.getCode())).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode())).build();
        WebSocketRuleHandle webSocketRuleHandle = new WebSocketRuleHandle();
        if (Objects.nonNull(annotations)) {
            webSocketRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
            webSocketRuleHandle.setRetry(Integer.parseInt(annotations.getOrDefault("shenyu.apache.org/retry", "0")));
            webSocketRuleHandle.setTimeout(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/timeout", "3000")));
        }
        RuleData ruleData = RuleData.builder().selectorId("1").pluginName(PluginEnum.WEB_SOCKET.getName()).name("default-rule").matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(Collections.singletonList(conditionData)).handle(GsonUtils.getInstance().toJson((Object)webSocketRuleHandle)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(Integer.MAX_VALUE)).build();
        return new IngressConfiguration(selectorData, Arrays.asList(ruleData), null);
    }
}

