/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.cache;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.common.exception.ShenyuException;

public final class IngressSecretCache {
    private static final IngressSecretCache INSTANCE = new IngressSecretCache();
    private static final Map<String, Set<String>> INGRESS_DOMAIN_MAP = Maps.newConcurrentMap();
    private static final Map<String, AtomicInteger> DOMAIN_NUMS_MAP = Maps.newConcurrentMap();

    private IngressSecretCache() {
    }

    public static IngressSecretCache getInstance() {
        return INSTANCE;
    }

    public void putDomainByIngress(String namespace, String ingressName, String domain) {
        Set set = INGRESS_DOMAIN_MAP.computeIfAbsent(this.getKey(namespace, ingressName), k -> new HashSet());
        set.add(domain);
    }

    public void putDomainByIngress(String namespace, String ingressName, Set<String> domainSet) {
        INGRESS_DOMAIN_MAP.put(this.getKey(namespace, ingressName), domainSet);
    }

    public Set<String> getDomainByIngress(String namespace, String ingressName) {
        return INGRESS_DOMAIN_MAP.get(this.getKey(namespace, ingressName));
    }

    public Set<String> removeDomainByIngress(String namespace, String ingressName) {
        return INGRESS_DOMAIN_MAP.remove(this.getKey(namespace, ingressName));
    }

    public Integer getAndIncrementDomainNums(String domain) {
        AtomicInteger count = DOMAIN_NUMS_MAP.computeIfAbsent(domain, k -> new AtomicInteger(0));
        return count.getAndIncrement();
    }

    public Integer getAndDecrementDomainNums(String domain) {
        AtomicInteger count = DOMAIN_NUMS_MAP.computeIfAbsent(domain, k -> new AtomicInteger(0));
        if (count.intValue() > 0) {
            return count.getAndDecrement();
        }
        throw new ShenyuException("Decrement when domain ssl counts <= 0, an unknown exception has occurred.");
    }

    private String getKey(String namespace, String name) {
        return namespace + "-" + name;
    }
}

