/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.spring.websocket.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.utils.PortUtils;
import org.apache.shenyu.client.spring.websocket.annotation.ShenyuServerEndpoint;
import org.apache.shenyu.client.spring.websocket.annotation.ShenyuSpringWebSocketClient;
import org.apache.shenyu.client.spring.websocket.init.ShenyuServerEndpointerExporter;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringWebSocketClientEventListener
extends AbstractContextRefreshedEventListener<Object, ShenyuSpringWebSocketClient> {
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String[] pathAttributeNames = new String[]{"path", "value"};
    private final List<Class<? extends Annotation>> mappingAnnotation = new ArrayList<Class<? extends Annotation>>(7);
    private final Boolean isFull;
    private final String protocol;

    public SpringWebSocketClientEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
        Properties props = clientConfig.getProps();
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.protocol = props.getProperty("protocol", "ws://");
        this.mappingAnnotation.add(ShenyuSpringWebSocketClient.class);
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, Object> beans) {
        ShenyuSpringWebSocketClient shenyuSpringWebSocketClient = (ShenyuSpringWebSocketClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSpringWebSocketClient.class);
        if (Objects.isNull(shenyuSpringWebSocketClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuSpringWebSocketClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.WEB_SOCKET, (Object)version);
    }

    protected Map<String, Object> getBeans(ApplicationContext context) {
        if (Boolean.TRUE.equals(this.isFull)) {
            LOG.info("init spring websocket client success with isFull mode");
            this.publisher.publishEvent((DataTypeParent)this.buildURIRegisterDTO(context, Collections.emptyMap()));
            return Collections.emptyMap();
        }
        Map endpointBeans = context.getBeansWithAnnotation(ShenyuServerEndpoint.class);
        this.registerEndpointsBeans(context, endpointBeans);
        return context.getBeansWithAnnotation(ShenyuSpringWebSocketClient.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, Object> beans) {
        try {
            return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getAppName()).protocol(this.protocol).host(super.getHost()).port(Integer.valueOf(this.getPort())).rpcType(RpcTypeEnum.WEB_SOCKET.getName()).eventType(EventType.REGISTER).build();
        }
        catch (ShenyuException e) {
            throw new ShenyuException(e.getMessage() + "please config ${shenyu.client.http.props.port} in xml/yml !");
        }
    }

    protected void handle(String beanName, Object bean) {
        Method[] methods;
        Class clazz = this.getCorrectedClass(bean);
        ShenyuSpringWebSocketClient beanShenyuClient = (ShenyuSpringWebSocketClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, this.getAnnotationType());
        String superPath = this.buildApiSuperPath(clazz, beanShenyuClient);
        if (Objects.nonNull(beanShenyuClient)) {
            this.handleClass(clazz, bean, beanShenyuClient, superPath);
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz)) {
            this.handleMethod(bean, clazz, beanShenyuClient, method, superPath);
        }
    }

    protected String buildApiSuperPath(Class<?> clazz, ShenyuSpringWebSocketClient webSocketClient) {
        if (Objects.nonNull(webSocketClient) && StringUtils.isNotBlank((CharSequence)webSocketClient.path())) {
            return webSocketClient.path();
        }
        return "";
    }

    protected void handleClass(Class<?> clazz, Object bean, @NonNull ShenyuSpringWebSocketClient beanShenyuClient, String superPath) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz)) {
            MetaDataRegisterDTO metaData = this.buildMetaDataDTO(bean, beanShenyuClient, this.pathJoin(new String[]{this.getContextPath(), superPath}), clazz, method);
            this.getPublisher().publishEvent((DataTypeParent)metaData);
            this.getMetaDataMap().put(method, metaData);
        }
    }

    protected void handleMethod(Object bean, Class<?> clazz, @Nullable ShenyuSpringWebSocketClient beanShenyuClient, Method method, String superPath) {
        ShenyuSpringWebSocketClient methodShenyuClient = (ShenyuSpringWebSocketClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.getAnnotationType());
        ShenyuSpringWebSocketClient shenyuSpringWebSocketClient = methodShenyuClient = Objects.isNull(methodShenyuClient) ? beanShenyuClient : methodShenyuClient;
        if (Objects.nonNull(methodShenyuClient)) {
            MetaDataRegisterDTO metaData = this.buildMetaDataDTO(bean, methodShenyuClient, this.buildApiPath(method, superPath, methodShenyuClient), clazz, method);
            this.getPublisher().publishEvent((DataTypeParent)metaData);
            this.getMetaDataMap().put(method, metaData);
        }
    }

    protected Class<ShenyuSpringWebSocketClient> getAnnotationType() {
        return ShenyuSpringWebSocketClient.class;
    }

    protected String buildApiPath(Method method, String superPath, ShenyuSpringWebSocketClient methodShenyuClient) {
        if (Objects.nonNull(methodShenyuClient) && StringUtils.isNotBlank((CharSequence)methodShenyuClient.path())) {
            return this.pathJoin(new String[]{this.getContextPath(), superPath, methodShenyuClient.path()});
        }
        String path = this.getPathByMethod(method);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.pathJoin(new String[]{this.getContextPath(), superPath, path});
        }
        return this.pathJoin(new String[]{this.getContextPath(), superPath});
    }

    protected MetaDataRegisterDTO buildMetaDataDTO(Object bean, @NonNull ShenyuSpringWebSocketClient webSocketClient, String path, Class<?> clazz, Method method) {
        return MetaDataRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getAppName()).path(UriComponentsBuilder.fromUriString((String)PathUtils.decoratorPathWithSlash((String)this.getContextPath())).build().encode().toUriString()).rpcType(RpcTypeEnum.WEB_SOCKET.getName()).enabled(true).ruleName((String)StringUtils.defaultIfBlank((CharSequence)webSocketClient.ruleName(), (CharSequence)this.getContextPath())).build();
    }

    public String getPort() {
        int port = Integer.parseInt(Optional.ofNullable(super.getPort()).orElseGet(() -> "-1"));
        int mergedPort = port <= 0 ? PortUtils.findPort((BeanFactory)this.getContext().getAutowireCapableBeanFactory()) : port;
        return String.valueOf(mergedPort);
    }

    private void registerEndpointsBeans(ApplicationContext context, Map<String, Object> endpointBeans) {
        if (CollectionUtils.isEmpty(endpointBeans)) {
            return;
        }
        ShenyuServerEndpointerExporter exporter = (ShenyuServerEndpointerExporter)((Object)this.registerBean(context, ShenyuServerEndpointerExporter.class, "shenyuServerEndpointerExporter"));
        for (Map.Entry<String, Object> entry : endpointBeans.entrySet()) {
            Class clazz = this.getCorrectedClass(entry.getValue());
            exporter.registerEndpoint(clazz);
        }
    }

    private String getPathByMethod(@NonNull Method method) {
        for (Class<? extends Annotation> mapping : this.mappingAnnotation) {
            String pathByAnnotation = this.getPathByAnnotation(AnnotationUtils.findAnnotation((Method)method, mapping), this.pathAttributeNames);
            if (!StringUtils.isNotBlank((CharSequence)pathByAnnotation)) continue;
            return pathByAnnotation;
        }
        return null;
    }

    private String getPathByAnnotation(@Nullable Annotation annotation, String ... pathAttributeName) {
        if (Objects.isNull(annotation)) {
            return null;
        }
        for (String s : pathAttributeName) {
            Object value = AnnotationUtils.getValue((Annotation)annotation, (String)s);
            if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
                return (String)value;
            }
            if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])((String[])value)) || !StringUtils.isNotBlank((CharSequence)((String[])value)[0])) continue;
            return ((String[])value)[0];
        }
        return null;
    }

    private Object registerBean(ApplicationContext applicationContext, Class<?> requiredType, String beanName) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(requiredType);
        defaultListableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        return configurableApplicationContext.getBean(requiredType);
    }
}

