/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.metadata;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetaData;

public final class RelationMetas {
    private final Map<String, RelationMetaData> relations;

    public boolean containsTable(String tableName) {
        return this.relations.containsKey(tableName);
    }

    public boolean containsColumn(String tableName, String columnName) {
        return this.relations.containsKey(tableName) && this.relations.get(tableName).getColumnNames().contains(columnName.toLowerCase());
    }

    public List<String> getAllColumnNames(String tableName) {
        return this.relations.containsKey(tableName) ? this.relations.get(tableName).getColumnNames() : Collections.emptyList();
    }

    @ConstructorProperties(value={"relations"})
    public RelationMetas(Map<String, RelationMetaData> relations) {
        this.relations = relations;
    }
}

