/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.ddl;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnPositionSegment;

public final class MySQLColumnPositionExtractor
implements OptionalSQLSegmentExtractor {
    private final String columnName;

    public Optional<ColumnPositionSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional firstOrAfterColumnNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)ancestorNode, (RuleName)RuleName.FIRST_OR_AFTER_COLUMN);
        if (!firstOrAfterColumnNode.isPresent()) {
            return Optional.absent();
        }
        Optional columnNameNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)firstOrAfterColumnNode.get()), (RuleName)RuleName.COLUMN_NAME);
        int startIndex = ((ParserRuleContext)firstOrAfterColumnNode.get()).getStart().getStartIndex();
        int stopIndex = ((ParserRuleContext)firstOrAfterColumnNode.get()).getStop().getStopIndex();
        ColumnAfterPositionSegment result = columnNameNode.isPresent() ? new ColumnAfterPositionSegment(startIndex, stopIndex, this.columnName, ((ParserRuleContext)columnNameNode.get()).getText()) : new ColumnFirstPositionSegment(startIndex, stopIndex, this.columnName);
        return Optional.of((Object)result);
    }

    @ConstructorProperties(value={"columnName"})
    public MySQLColumnPositionExtractor(String columnName) {
        this.columnName = columnName;
    }
}

