/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.insert;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.OnDuplicateKeyColumnsSegment;

public final class OnDuplicateKeyColumnsExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Optional<OnDuplicateKeyColumnsSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> onDuplicateKeyClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.ON_DUPLICATE_KEY_CLAUSE);
        if (!onDuplicateKeyClauseNode.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new OnDuplicateKeyColumnsSegment(((ParserRuleContext)onDuplicateKeyClauseNode.get()).getStart().getStartIndex(), ((ParserRuleContext)onDuplicateKeyClauseNode.get()).getStop().getStopIndex(), this.extractColumnSegments((ParserRuleContext)onDuplicateKeyClauseNode.get(), parameterMarkerIndexes)));
    }

    private Collection<ColumnSegment> extractColumnSegments(ParserRuleContext onDuplicateKeyClauseNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(onDuplicateKeyClauseNode, RuleName.COLUMN_NAME)) {
            Optional<ColumnSegment> columnSegment = this.columnExtractor.extract(each, parameterMarkerIndexes);
            if (!columnSegment.isPresent()) continue;
            result.add((ColumnSegment)columnSegment.get());
        }
        return result;
    }
}

