/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.ddl.column;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.ddl.column.ColumnDefinitionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.AddColumnDefinitionSegment;

public class AddColumnDefinitionExtractor
implements CollectionSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionExtractor = new ColumnDefinitionExtractor();

    public final Collection<AddColumnDefinitionSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        LinkedList<AddColumnDefinitionSegment> result = new LinkedList<AddColumnDefinitionSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ADD_COLUMN_SPECIFICATION)) {
            result.addAll(this.extractAddColumnDefinitions(each, parameterMarkerIndexes));
        }
        return result;
    }

    private Collection<AddColumnDefinitionSegment> extractAddColumnDefinitions(ParserRuleContext addColumnNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        LinkedList<AddColumnDefinitionSegment> result = new LinkedList<AddColumnDefinitionSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(addColumnNode, RuleName.COLUMN_DEFINITION)) {
            Optional<ColumnDefinitionSegment> columnDefinitionSegment = this.columnDefinitionExtractor.extract(each, parameterMarkerIndexes);
            if (!columnDefinitionSegment.isPresent()) continue;
            AddColumnDefinitionSegment addColumnDefinitionSegment = new AddColumnDefinitionSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), (ColumnDefinitionSegment)columnDefinitionSegment.get());
            this.postExtractColumnDefinition(addColumnNode, addColumnDefinitionSegment, parameterMarkerIndexes);
            result.add(addColumnDefinitionSegment);
        }
        return result;
    }

    protected void postExtractColumnDefinition(ParserRuleContext addColumnNode, AddColumnDefinitionSegment addColumnDefinitionSegment, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
    }
}

