/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.res;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.servicemix.maven.plugin.res.InterpolationFilterReader;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class ResMojo
extends AbstractMojo {
    private String encoding;
    private String inputDirectory;
    private String outputDirectory;
    private MavenProject project;
    private String beginToken = "@{";
    private String endToken = "}";
    private Map filters;

    public void execute() throws MojoExecutionException {
        if (this.encoding == null || this.encoding.length() < 1) {
            this.getLog().info((CharSequence)"Using default encoding to copy filtered resources.");
        } else {
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' to copy filtered resources."));
        }
        if (!new File(this.inputDirectory).exists() || !new File(this.inputDirectory).isDirectory()) {
            this.getLog().warn((CharSequence)"Input directory does not exists. Exiting plugin.");
            return;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.inputDirectory);
        scanner.setIncludes(new String[]{"**/**"});
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        this.getLog().info((CharSequence)("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "")));
        for (String name : includedFiles) {
            File source = new File(this.inputDirectory, name);
            File destinationFile = new File(this.outputDirectory, name);
            if (!destinationFile.getParentFile().exists()) {
                destinationFile.getParentFile().mkdirs();
            }
            try {
                this.copyFile(source, destinationFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying resource " + source, (Exception)e);
            }
        }
    }

    private void copyFile(File from, File to) throws IOException {
        FileUtils.FilterWrapper[] wrappers = new FileUtils.FilterWrapper[]{new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                return new InterpolationFilterReader(reader, ResMojo.this.filters, ResMojo.this.beginToken, ResMojo.this.endToken);
            }
        }};
        FileUtils.copyFile((File)from, (File)to, (String)this.encoding, (FileUtils.FilterWrapper[])wrappers);
    }
}

