/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.http.client.common.URLEndPoint;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAddressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddressManager.class);
    public static final String DEFAULT_PROJECT = "default";
    public static final String V4_PREFIX = "/v4/";
    private static final String V3_PREFIX = "/v3/";
    private static final int DEFAULT_METRICS_WINDOW_TIME = 1;
    private static final int ISOLATION_THRESHOLD = 3;
    private List<String> addresses = new ArrayList<String>();
    private int index = 0;
    private String projectName;
    private Map<String, Boolean> categoryMap = new HashMap<String, Boolean>();
    private Map<String, Integer> recodeStatus = new ConcurrentHashMap<String, Integer>();
    private Map<String, Boolean> history = new ConcurrentHashMap<String, Boolean>();
    private volatile List<String> availableZone = new ArrayList<String>();
    private volatile List<String> availableRegion = new ArrayList<String>();
    private volatile List<String> defaultAddress = new ArrayList<String>();
    private boolean isAddressRefresh = false;
    private final Object lock = new Object();
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("check-available-address-%d").build());
    private Cache<String, Boolean> cacheAddress = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public AbstractAddressManager(List<String> addresses) {
        this.addresses.addAll(addresses);
    }

    public AbstractAddressManager(String projectName, List<String> addresses) {
        this.projectName = StringUtils.isEmpty((String)projectName) ? DEFAULT_PROJECT : projectName;
        this.addresses = this.transformAddress(addresses);
        this.defaultAddress = this.addresses;
    }

    @VisibleForTesting
    protected void setAddressRefresh(boolean addressRefresh) {
        this.isAddressRefresh = addressRefresh;
    }

    private void startCheck() {
        this.executorService.scheduleAtFixedRate(this::checkHistory, 0L, 1L, TimeUnit.MINUTES);
    }

    public String formatUrl(String url, boolean absoluteUrl, String address) {
        return absoluteUrl ? address + url : this.formatAddress(address) + url;
    }

    public String address() {
        if (!this.isAddressRefresh) {
            return this.getDefaultAddress();
        }
        return this.getAvailableZoneAddress();
    }

    public boolean sslEnabled() {
        return this.address().startsWith("https://");
    }

    protected List<String> transformAddress(List<String> addresses) {
        return addresses.stream().map(this::formatAddress).collect(Collectors.toList());
    }

    protected String getUrlPrefix(String address) {
        return address + V3_PREFIX;
    }

    protected String formatAddress(String address) {
        try {
            return this.getUrlPrefix(address) + HttpUtils.encodeURLParam(this.projectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("not possible");
        }
    }

    private String getDefaultAddress() {
        List<String> addresses = this.getAvailableAddress(this.defaultAddress);
        if (!addresses.isEmpty()) {
            return this.getCurrentAddress(addresses);
        }
        return this.getInitAddress();
    }

    private String getAvailableZoneAddress() {
        List<String> addresses = this.getAvailableZoneIpPorts();
        if (!addresses.isEmpty()) {
            return this.joinProject(this.getCurrentAddress(addresses));
        }
        return this.getInitAddress();
    }

    private String getInitAddress() {
        if (this.addresses.isEmpty()) {
            return null;
        }
        return this.getCurrentAddress(this.addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentAddress(List<String> addresses) {
        AbstractAddressManager abstractAddressManager = this;
        synchronized (abstractAddressManager) {
            ++this.index;
            if (this.index >= addresses.size()) {
                this.index = 0;
            }
            return addresses.get(this.index);
        }
    }

    protected String joinProject(String address) {
        return address;
    }

    private List<String> getAvailableZoneIpPorts() {
        ArrayList<String> results = new ArrayList<String>();
        if (!this.availableZone.isEmpty()) {
            results.addAll(this.getAvailableAddress(this.availableZone));
        } else {
            results.addAll(this.getAvailableAddress(this.availableRegion));
        }
        return results;
    }

    private List<String> getAvailableAddress(List<String> endpoints) {
        List<String> list = endpoints.stream().filter(uri -> !this.history.containsKey(uri)).collect(Collectors.toList());
        return list;
    }

    protected String normalizeUri(String endpoint) {
        return new URLEndPoint(endpoint).toString();
    }

    public void refreshEndpoint(RefreshEndpointEvent event, String key) {
        this.setAddressRefresh(true);
        if (null == event || !event.getName().equals(key)) {
            return;
        }
        this.availableZone = event.getSameZone().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.availableRegion = event.getSameRegion().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.availableZone.forEach(address -> this.categoryMap.put((String)address, true));
        this.availableRegion.forEach(address -> this.categoryMap.put((String)address, false));
        this.startCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFailState(String address) {
        if (!this.recodeStatus.containsKey(address)) {
            this.recodeStatus.put(address, 1);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int number = this.recodeStatus.get(address) + 1;
            if (number < 3) {
                this.recodeStatus.put(address, number);
            } else {
                this.removeAddress(address);
            }
        }
    }

    public void recordSuccessState(String address) {
        this.recodeStatus.put(address, 0);
    }

    @VisibleForTesting
    protected void checkHistory() {
        this.history.keySet().stream().filter(this::judgeIsolation).forEach(s -> {
            if (this.telnetTest((String)s)) {
                this.rejoinAddress((String)s);
            } else {
                this.cacheAddress.put(s, (Object)false);
            }
        });
    }

    private Boolean judgeIsolation(String address) {
        try {
            return (Boolean)this.cacheAddress.get((Object)address, () -> true);
        }
        catch (ExecutionException e) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean telnetTest(String address) {
        URI ipPort = this.parseIpPortFromURI(address);
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(ipPort.getHost(), ipPort.getPort()), 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.warn("ping endpoint {} failed, It will be quarantined again.", (Object)address);
            return false;
        }
    }

    private URI parseIpPortFromURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @VisibleForTesting
    void rejoinAddress(String address) {
        if (!this.isAddressRefresh) {
            this.defaultAddress.add(address);
        } else if (this.categoryMap.get(address).booleanValue()) {
            this.availableZone.add(address);
        } else {
            this.availableRegion.add(address);
        }
        this.recodeStatus.put(address, 0);
        this.history.remove(address);
    }

    @VisibleForTesting
    void removeAddress(String address) {
        if (!this.isAddressRefresh) {
            this.defaultAddress.remove(address);
            this.history.put(address, false);
        } else {
            if (this.categoryMap.get(address).booleanValue()) {
                this.availableZone.remove(address);
            } else {
                this.availableRegion.remove(address);
            }
            this.history.put(address, this.categoryMap.get(address));
        }
        this.recodeStatus.put(address, 0);
        this.cacheAddress.put((Object)address, (Object)false);
    }
}

