/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLManager;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.SSLSocketFactoryExt;
import org.apache.servicecomb.http.client.common.WebSocketListener;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketTransport
extends WebSocketClient {
    public static final int CONNECT_TIMEOUT = 5000;
    private WebSocketListener webSocketListener;

    public WebSocketTransport(String serverUri, HttpConfiguration.SSLProperties sslProperties, Map<String, String> headers, WebSocketListener webSocketListener) throws URISyntaxException {
        super(new URI(serverUri), (Draft)new Draft_6455(), headers, 5000);
        if (sslProperties.isEnabled()) {
            SSLSocketFactory sslSocketFactory = SSLManager.createSSLSocketFactory((SSLOption)sslProperties.getSslOption(), (SSLCustom)sslProperties.getSslCustom());
            URI uri = new URI(serverUri);
            this.setSocketFactory(new SSLSocketFactoryExt(sslSocketFactory, uri.getHost(), uri.getPort()));
        }
        this.webSocketListener = webSocketListener;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        this.webSocketListener.onOpen(serverHandshake);
    }

    public void onMessage(String s) {
        this.webSocketListener.onMessage(s);
    }

    public void onClose(int code, String reason, boolean remote) {
        this.webSocketListener.onClose(code, reason, remote);
    }

    public void onError(Exception e) {
        this.webSocketListener.onError(e);
    }
}

