/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.servicecomb.http.client.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTask.class);
    private final ExecutorService taskPool = Executors.newSingleThreadExecutor(task -> new Thread(task, taskName));

    protected AbstractTask(String taskName) {
    }

    protected void startTask(Task task) {
        try {
            this.taskPool.execute(() -> {
                try {
                    task.execute();
                }
                catch (Throwable e) {
                    LOGGER.error("unexpected error execute task {}", (Object)task.getClass().getName(), (Object)e);
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("execute task rejected {}", (Object)task.getClass().getName(), (Object)e);
        }
    }

    public void stop() {
        this.taskPool.shutdownNow();
    }

    public class BackOffSleepTask
    implements Task {
        final long base = 3000L;
        final long max = 6000000L;
        long waitTime;
        Task nextTask;

        public BackOffSleepTask(int failedCount, Task nextTask) {
            this.waitTime = (long)(failedCount * failedCount) * 3000L;
            this.nextTask = nextTask;
        }

        public BackOffSleepTask(long waitTime, Task nextTask) {
            this.waitTime = waitTime;
            this.nextTask = nextTask;
        }

        @Override
        public void execute() {
            long time = Math.min(6000000L, this.waitTime);
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                LOGGER.error("unexpected interrupt during sleep", (Throwable)e);
            }
            AbstractTask.this.startTask(this.nextTask);
        }
    }
}

