/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common.auth;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.http.client.common.auth.AKSKHeaderExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemMountAKSKHeaderExtension
extends AKSKHeaderExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemMountAKSKHeaderExtension.class);
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    public FileSystemMountAKSKHeaderExtension() {
        try {
            Path p = Paths.get("/opt/CSE/etc/auth", new String[0]);
            if (!p.toFile().exists()) {
                return;
            }
            WatchService watchService = FileSystems.getDefault().newWatchService();
            p.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.executor.execute(new FileUpdateCheckThread(watchService));
        }
        catch (Exception e) {
            LOGGER.warn("get watch service failed.", (Throwable)e);
        }
    }

    @Override
    public void createAuthHeaders() {
        try {
            String content = new String(Files.readAllBytes(Paths.get("/opt/CSE/etc/auth", ".dockerconfigjson")), "UTF-8");
            JsonNode data = HttpUtils.readTree(content);
            JsonNode authNode = data.findValue("auth");
            this.decode(authNode);
        }
        catch (Exception e) {
            LOGGER.warn("read auth info from dockerconfigjson failed.", (Throwable)e);
        }
    }

    final class FileUpdateCheckThread
    implements Runnable {
        private WatchService service;

        private FileUpdateCheckThread(WatchService service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WatchKey watchKey = this.service.take();
                        watchKey.pollEvents();
                        FileUpdateCheckThread fileUpdateCheckThread = this;
                        synchronized (fileUpdateCheckThread) {
                            FileSystemMountAKSKHeaderExtension.this.createAuthHeaders();
                        }
                        watchKey.reset();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("error occured. detail : {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

