/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.cache;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.ServiceInfoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.yaml.snakeyaml.Yaml;

public class RouterRuleCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterRuleCache.class);
    private static ConcurrentHashMap<String, ServiceInfoCache> serviceInfoCacheMap = new ConcurrentHashMap();
    private static final String ROUTE_RULE = "servicecomb.routeRule.%s";
    private static Interner<String> servicePool = Interners.newWeakInterner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doInit(String targetServiceName) {
        if (!RouterRuleCache.isServerContainRule(targetServiceName)) {
            return false;
        }
        if (!serviceInfoCacheMap.containsKey(targetServiceName)) {
            String string = (String)servicePool.intern((Object)targetServiceName);
            synchronized (string) {
                if (serviceInfoCacheMap.containsKey(targetServiceName)) {
                    return true;
                }
                DynamicStringProperty ruleStr = DynamicPropertyFactory.getInstance().getStringProperty(String.format(ROUTE_RULE, targetServiceName), null, () -> {
                    RouterRuleCache.refresh(targetServiceName);
                    DynamicStringProperty tepRuleStr = DynamicPropertyFactory.getInstance().getStringProperty(String.format(ROUTE_RULE, targetServiceName), null);
                    RouterRuleCache.addAllRule(targetServiceName, tepRuleStr.get());
                });
                return RouterRuleCache.addAllRule(targetServiceName, ruleStr.get());
            }
        }
        return true;
    }

    private static boolean addAllRule(String targetServiceName, String ruleStr) {
        List<Object> policyRuleItemList;
        if (StringUtils.isEmpty((CharSequence)ruleStr)) {
            return false;
        }
        Yaml yaml = new Yaml();
        try {
            policyRuleItemList = Arrays.asList((Object[])yaml.loadAs(ruleStr, PolicyRuleItem[].class));
        }
        catch (Exception e) {
            LOGGER.error("route management Serialization failed: {}", (Object)e.getMessage());
            return false;
        }
        if (CollectionUtils.isEmpty(policyRuleItemList)) {
            return false;
        }
        ServiceInfoCache serviceInfoCache = new ServiceInfoCache(policyRuleItemList);
        serviceInfoCacheMap.put(targetServiceName, serviceInfoCache);
        return true;
    }

    public static boolean isServerContainRule(String targetServiceName) {
        DynamicStringProperty lookFor = DynamicPropertyFactory.getInstance().getStringProperty(String.format(ROUTE_RULE, targetServiceName), null);
        return !StringUtils.isEmpty((CharSequence)lookFor.get());
    }

    public static ConcurrentHashMap<String, ServiceInfoCache> getServiceInfoCacheMap() {
        return serviceInfoCacheMap;
    }

    public static void refresh() {
        serviceInfoCacheMap = new ConcurrentHashMap();
    }

    public static void refresh(String targetServiceName) {
        serviceInfoCacheMap.remove(targetServiceName);
    }
}

