/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public abstract class DynamicEnum<T> {
    private T value;
    @JsonIgnore
    private boolean dynamic = false;

    public DynamicEnum(T value) {
        this.value = value;
    }

    @JsonValue
    public T getValue() {
        return this.value;
    }

    @JsonIgnore
    public boolean isStatic() {
        return !this.dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public DynamicEnum<T> setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicEnum that = (DynamicEnum)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

