/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.param.RestClientRequestImpl;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;

public class ClientRestArgsFilter
implements HttpClientFilter {
    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public void beforeSendRequest(Invocation invocation, HttpServletRequestEx requestEx) {
        RestClientRequestImpl restClientRequest = (RestClientRequestImpl)invocation.getHandlerContext().get("servicecomb-invocation-hanlder-requestclient");
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        try {
            RestCodec.argsToRest(invocation.getSwaggerArguments(), swaggerRestOperation, restClientRequest);
            requestEx.setBodyBuffer(restClientRequest.getBodyBuffer());
        }
        catch (Throwable e) {
            throw ExceptionFactory.convertConsumerException((Throwable)e);
        }
    }

    @Override
    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        return null;
    }
}

