/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.FormProcessorCreator;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.common.rest.definition.path.PathRegExp;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.utils.MimeTypesUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOperationMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestOperationMeta.class);
    protected OperationMeta operationMeta;
    protected List<String> produces;
    protected boolean formData;
    protected boolean downloadFile;
    protected List<RestParam> paramList = new ArrayList<RestParam>();
    protected Map<String, RestParam> paramMap = new LinkedHashMap<String, RestParam>();
    protected List<String> fileKeys = new ArrayList<String>();
    private Map<String, ProduceProcessor> produceProcessorMap = new LinkedHashMap<String, ProduceProcessor>();
    private ProduceProcessor defaultProcessor;
    protected String absolutePath;
    protected PathRegExp absolutePathRegExp;
    private URLPathBuilder pathBuilder;

    public void init(OperationMeta operationMeta) {
        this.operationMeta = operationMeta;
        Swagger swagger = operationMeta.getSchemaMeta().getSwagger();
        Operation operation = operationMeta.getSwaggerOperation();
        this.produces = operation.getProduces();
        if (this.produces == null) {
            this.produces = swagger.getProduces();
        }
        this.downloadFile = this.checkDownloadFileFlag();
        this.createProduceProcessors();
        for (int swaggerParameterIdx = 0; swaggerParameterIdx < operation.getParameters().size(); ++swaggerParameterIdx) {
            Parameter parameter = (Parameter)operation.getParameters().get(swaggerParameterIdx);
            if ("formData".equals(parameter.getIn())) {
                this.formData = true;
            }
            Type type = operationMeta.getSwaggerProducerOperation() != null ? (Type)operationMeta.getSwaggerProducerOperation().getSwaggerParameterTypes().get(parameter.getName()) : null;
            type = this.correctFormBodyType(parameter, type);
            RestParam param = new RestParam(parameter, type);
            this.addParam(param);
        }
        this.setAbsolutePath(this.concatPath(swagger.getBasePath(), operationMeta.getOperationPath()));
    }

    private Type correctFormBodyType(Parameter parameter, Type type) {
        if (null != type || !(parameter instanceof BodyParameter)) {
            return type;
        }
        BodyParameter bodyParameter = (BodyParameter)parameter;
        if (!(bodyParameter.getSchema() instanceof ModelImpl)) {
            return type;
        }
        Property additionalProperties = ((ModelImpl)bodyParameter.getSchema()).getAdditionalProperties();
        if (additionalProperties instanceof StringProperty) {
            type = RestObjectMapperFactory.getRestObjectMapper().getTypeFactory().constructMapType(Map.class, String.class, String.class);
        }
        return type;
    }

    public boolean isDownloadFile() {
        return this.downloadFile;
    }

    private boolean checkDownloadFileFlag() {
        Response response = (Response)this.operationMeta.getSwaggerOperation().getResponses().get("200");
        if (response != null) {
            Model model = response.getResponseSchema();
            return model instanceof ModelImpl && FileProperty.isType((String)((ModelImpl)model).getType(), (String)((ModelImpl)model).getFormat());
        }
        return false;
    }

    public boolean isFormData() {
        return this.formData;
    }

    public void setOperationMeta(OperationMeta operationMeta) {
        this.operationMeta = operationMeta;
    }

    private String concatPath(String basePath, String operationPath) {
        return ("/" + this.nonNullify(basePath) + "/" + this.nonNullify(operationPath) + "/").replaceAll("/{2,}", "/");
    }

    private String nonNullify(String path) {
        return path == null ? "" : path;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
        this.absolutePathRegExp = this.createPathRegExp(absolutePath);
        this.pathBuilder = new URLPathBuilder(absolutePath, this.paramMap);
    }

    public PathRegExp getAbsolutePathRegExp() {
        return this.absolutePathRegExp;
    }

    public boolean isAbsoluteStaticPath() {
        return this.absolutePathRegExp.isStaticPath();
    }

    protected PathRegExp createPathRegExp(String path) {
        if (path == null || path.equals("")) {
            throw new Error("null rest url is not supported");
        }
        try {
            return new PathRegExp(path);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public RestParam getParamByName(String name) {
        return this.paramMap.get(name);
    }

    public RestParam getParamByIndex(int index) {
        return this.paramList.get(index);
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    protected void createProduceProcessors() {
        SwaggerProducerOperation producerOperation = (SwaggerProducerOperation)this.operationMeta.getExtData("producer-operation");
        if (producerOperation != null && producerOperation.getProducerMethod() != null) {
            this.createProduceProcessors(producerOperation.getProducerMethod().getDeclaredAnnotations());
            return;
        }
        this.createProduceProcessors(null);
    }

    protected void createProduceProcessors(Annotation[] annotations) {
        if (annotations == null || annotations.length < 1) {
            this.doCreateProduceProcessors(null);
            return;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != JsonView.class) continue;
            Class[] value = ((JsonView)annotation).value();
            if (value.length != 1) {
                throw new IllegalArgumentException("@JsonView only supported for exactly 1 class argument ");
            }
            this.doCreateProduceProcessors(value[0]);
            return;
        }
        this.doCreateProduceProcessors(null);
    }

    protected void doCreateProduceProcessors(Class<?> serialViewClass) {
        if (null == this.produces || this.produces.isEmpty()) {
            this.produceProcessorMap.putAll(ProduceProcessorManager.INSTANCE.getOrCreateAcceptMap(serialViewClass));
        } else {
            for (String produce : this.produces) {
                ProduceProcessor processor;
                if (produce.contains(";")) {
                    produce = produce.substring(0, produce.indexOf(";"));
                }
                if ((processor = ProduceProcessorManager.INSTANCE.findProcessor(produce, serialViewClass)) == null) {
                    LOGGER.error("produce {} is not supported, operation={}.", (Object)produce, (Object)this.operationMeta.getMicroserviceQualifiedName());
                    continue;
                }
                this.produceProcessorMap.put(produce, processor);
            }
            if (this.produceProcessorMap.isEmpty()) {
                this.produceProcessorMap.put("application/json", ProduceProcessorManager.INSTANCE.findDefaultProcessorByViewClass(serialViewClass));
            }
        }
        this.defaultProcessor = this.produceProcessorMap.values().stream().findFirst().get();
        this.produceProcessorMap.putIfAbsent("*/*", this.defaultProcessor);
    }

    public URLPathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    public List<RestParam> getParamList() {
        return this.paramList;
    }

    private void addParam(RestParam param) {
        if (param.getParamProcessor() instanceof FormProcessorCreator.PartProcessor) {
            this.fileKeys.add(param.getParamName());
        }
        this.paramList.add(param);
        this.paramMap.put(param.getParamName(), param);
    }

    public ProduceProcessor findProduceProcessor(String type) {
        return this.produceProcessorMap.get(type);
    }

    public ProduceProcessor ensureFindProduceProcessor(HttpServletRequestEx requestEx) {
        String acceptType = requestEx.getHeader("Accept");
        return this.ensureFindProduceProcessor(acceptType);
    }

    public ProduceProcessor ensureFindProduceProcessor(String acceptType) {
        if (this.downloadFile) {
            return this.produceProcessorMap.get("*/*");
        }
        if (StringUtils.isEmpty((CharSequence)acceptType)) {
            return this.defaultProcessor;
        }
        List mimeTypes = MimeTypesUtils.getSortedAcceptableMimeTypes((String)acceptType.toLowerCase(Locale.US));
        for (String mime : mimeTypes) {
            ProduceProcessor processor = this.produceProcessorMap.get(mime);
            if (null == processor) continue;
            return processor;
        }
        return null;
    }

    public String getHttpMethod() {
        return this.operationMeta.getHttpMethod();
    }

    public List<String> getFileKeys() {
        return this.fileKeys;
    }

    public List<String> getProduces() {
        return this.produces;
    }
}

