/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.MetadataUtil;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.format.json.debezium.DebeziumRowConverter;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class DebeziumJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String OP_KEY = "op";
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    public static final String DATA_PAYLOAD = "payload";
    private static final String DATA_BEFORE = "before";
    private static final String DATA_AFTER = "after";
    private static final String DATA_TS = "ts_ms";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s operation is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    public static final String FORMAT = "Debezium";
    private final SeaTunnelRowType rowType;
    private final JsonDeserializationSchema jsonDeserializer;
    private final DebeziumRowConverter debeziumRowConverter;
    private final boolean ignoreParseErrors;
    private final boolean debeziumEnabledSchema;
    private final TablePath tablePath;

    public DebeziumJsonDeserializationSchema(CatalogTable catalogTable, boolean ignoreParseErrors) {
        this(catalogTable, ignoreParseErrors, false);
    }

    public DebeziumJsonDeserializationSchema(CatalogTable catalogTable, boolean ignoreParseErrors, boolean debeziumEnabledSchema) {
        this.rowType = catalogTable.getSeaTunnelRowType();
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonDeserializationSchema(catalogTable, false, ignoreParseErrors);
        this.debeziumRowConverter = new DebeziumRowConverter(this.rowType);
        this.debeziumEnabledSchema = debeziumEnabledSchema;
        this.tablePath = Optional.of(catalogTable).map(CatalogTable::getTablePath).orElse(null);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) {
        this.deserializeMessage(message, out, this.tablePath);
    }

    public void deserializeMessage(byte[] message, Collector<SeaTunnelRow> out, TablePath tablePath) {
        block3: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                JsonNode payload = this.getPayload(this.jsonDeserializer.deserializeToJsonNode(message));
                this.parsePayload(out, tablePath, payload);
            }
            catch (Exception e) {
                if (this.ignoreParseErrors) break block3;
                throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)e);
            }
        }
    }

    public void parsePayload(Collector<SeaTunnelRow> out, JsonNode payload) throws IOException {
        this.parsePayload(out, this.tablePath, payload);
    }

    private void parsePayload(Collector<SeaTunnelRow> out, TablePath tablePath, JsonNode payload) throws IOException {
        String op = payload.get(OP_KEY).asText();
        JsonNode tsNode = payload.get(DATA_TS);
        switch (op) {
            case "c": 
            case "r": {
                SeaTunnelRow insert = this.debeziumRowConverter.parse(payload.get(DATA_AFTER));
                insert.setRowKind(RowKind.INSERT);
                if (tablePath != null) {
                    insert.setTableId(tablePath.toString());
                }
                if (tsNode != null) {
                    MetadataUtil.setEventTime((SeaTunnelRow)insert, (Long)tsNode.asLong());
                }
                out.collect((Object)insert);
                break;
            }
            case "u": {
                SeaTunnelRow before = this.debeziumRowConverter.parse(payload.get(DATA_BEFORE));
                if (before == null) {
                    throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                }
                before.setRowKind(RowKind.UPDATE_BEFORE);
                if (tablePath != null) {
                    before.setTableId(tablePath.toString());
                }
                if (tsNode != null) {
                    MetadataUtil.setEventTime((SeaTunnelRow)before, (Long)tsNode.asLong());
                }
                out.collect((Object)before);
                SeaTunnelRow after = this.debeziumRowConverter.parse(payload.get(DATA_AFTER));
                after.setRowKind(RowKind.UPDATE_AFTER);
                if (tablePath != null) {
                    after.setTableId(tablePath.toString());
                }
                if (tsNode != null) {
                    MetadataUtil.setEventTime((SeaTunnelRow)after, (Long)tsNode.asLong());
                }
                out.collect((Object)after);
                break;
            }
            case "d": {
                SeaTunnelRow delete = this.debeziumRowConverter.parse(payload.get(DATA_BEFORE));
                if (delete == null) {
                    throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                }
                delete.setRowKind(RowKind.DELETE);
                if (tablePath != null) {
                    delete.setTableId(tablePath.toString());
                }
                if (tsNode != null) {
                    MetadataUtil.setEventTime((SeaTunnelRow)delete, (Long)tsNode.asLong());
                }
                out.collect((Object)delete);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown operation type '%s'.", op));
            }
        }
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowType;
    }

    private JsonNode getPayload(JsonNode jsonNode) {
        if (this.debeziumEnabledSchema) {
            return jsonNode.get(DATA_PAYLOAD);
        }
        return jsonNode;
    }
}

