/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.source;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplit;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitEnumeratorState;

public class SingleSplitEnumerator
implements SourceSplitEnumerator<SingleSplit, SingleSplitEnumeratorState> {
    protected final SourceSplitEnumerator.Context<SingleSplit> context;
    protected SingleSplit pendingSplit;
    protected volatile boolean assigned = false;

    public SingleSplitEnumerator(SourceSplitEnumerator.Context<SingleSplit> context) {
        this.context = context;
    }

    public void open() {
    }

    public void run() throws Exception {
        if (this.assigned || this.pendingSplit != null) {
            return;
        }
        this.pendingSplit = new SingleSplit(null);
        this.assignSplit();
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<SingleSplit> splits, int subtaskId) {
        this.pendingSplit = splits.get(0);
        this.assignSplit();
    }

    protected void assignSplit() {
        if (this.assigned || this.pendingSplit == null) {
            return;
        }
        Set readers = this.context.registeredReaders();
        if (!readers.isEmpty()) {
            this.context.assignSplit(((Integer)readers.stream().findFirst().get()).intValue(), (SourceSplit)this.pendingSplit);
            this.assigned = true;
        }
    }

    public int currentUnassignedSplitSize() {
        return 0;
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
        this.assignSplit();
    }

    public SingleSplitEnumeratorState snapshotState(long checkpointId) throws Exception {
        return new SingleSplitEnumeratorState();
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

