/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.util.List;
import java.util.Objects;
import org.tikv.common.exception.TiExpressionException;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.Visitor;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.types.DataType;
import org.tikv.shade.com.google.common.collect.ImmutableList;

public class ColumnRef
extends Expression {
    private final String name;

    @Deprecated
    public ColumnRef(String name) {
        this.name = name;
    }

    public ColumnRef(String name, DataType dataType) {
        super(dataType);
        this.resolved = true;
        this.name = name;
    }

    public static ColumnRef create(String name, TiTableInfo table) {
        TiColumnInfo col = table.getColumn(name = name.replaceAll("`", ""));
        if (col != null) {
            return new ColumnRef(name, col.getType());
        }
        throw new TiExpressionException(String.format("Column name %s not found in table %s", name, table));
    }

    @Deprecated
    public static ColumnRef create(String name) {
        return new ColumnRef(name);
    }

    public static ColumnRef create(String name, DataType dataType) {
        return new ColumnRef(name, dataType);
    }

    public static ColumnRef create(String name, TiColumnInfo columnInfo) {
        return new ColumnRef(name, columnInfo.getType());
    }

    public String getName() {
        return this.name.toLowerCase();
    }

    public void resolve(TiTableInfo table) {
        TiColumnInfo columnInfo = null;
        for (TiColumnInfo col : table.getColumns()) {
            if (!col.matchName(this.name)) continue;
            this.dataType = col.getType();
            columnInfo = col;
            break;
        }
        if (columnInfo == null) {
            throw new TiExpressionException(String.format("No Matching column %s from table %s", this.name, table.getName()));
        }
        if (columnInfo.getId() == 0L) {
            throw new TiExpressionException("Zero Id is not a referable column id");
        }
    }

    public boolean matchName(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another instanceof ColumnRef) {
            ColumnRef that = (ColumnRef)another;
            if (this.isResolved() && that.isResolved()) {
                return this.name.equalsIgnoreCase(that.name) && this.dataType.equals(((ColumnRef)another).dataType);
            }
            return this.name.equalsIgnoreCase(that.name);
        }
        return false;
    }

    public int hashCode() {
        if (this.isResolved()) {
            return Objects.hash(this.name, this.dataType);
        }
        return Objects.hashCode(this.name);
    }

    public String toString() {
        if (this.dataType != null) {
            return String.format("%s@%s", this.getName(), this.dataType.getName());
        }
        return String.format("[%s]", this.getName());
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }
}

