/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.opengauss;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql.PostgresDialect;

public class OpenGaussDialect
extends PostgresDialect {
    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String updateClause = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).map(fieldName -> this.quoteIdentifier((String)fieldName) + "=EXCLUDED." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        if (updateClause.isEmpty()) {
            return Optional.empty();
        }
        String upsertSQL = String.format("%s ON DUPLICATE KEY UPDATE %s", this.getInsertIntoStatement(database, tableName, fieldNames), updateClause);
        return Optional.of(upsertSQL);
    }
}

