/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmdbDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(DmdbDialect.class);
    public String fieldIde;

    public DmdbDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "Dameng";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new DmdbJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new DmdbTypeMapper();
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String databaseName = this.tableIdentifier(database, tableName);
        String upsertSQL = String.format(" MERGE INTO %s TARGET USING (%s) SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", databaseName, usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public String extractTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return tablePath.getSchemaAndTableName("\"");
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        if (database == null) {
            return this.quoteIdentifier(tableName);
        }
        if (tableName.contains(".")) {
            return this.quoteIdentifier(tableName);
        }
        return this.quoteDatabaseIdentifier(database) + "." + this.quoteIdentifier(tableName);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public TypeConverter<BasicTypeDefine> getTypeConverter() {
        return DmdbTypeConverter.INSTANCE;
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableAddColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        Column column = event.getColumn();
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(column);
        String columnType = sameCatalog ? column.getSourceType() : typeDefine.getColumnType();
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE ").append(this.tableIdentifier(tablePath)).append(" ADD ").append(this.quoteIdentifier(column.getName())).append(" ").append(columnType);
        if (!(column.getDefaultValue() == null || column.isNullable() || !sameCatalog && this.isSpecialDefaultValue(typeDefine.getDefaultValue(), sourceDialectName))) {
            String defaultValueClause = this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName);
            sqlBuilder.append(" NOT NULL ").append(defaultValueClause);
        } else {
            if (column.getDefaultValue() != null && this.isSpecialDefaultValue(typeDefine.getDefaultValue(), sourceDialectName)) {
                log.warn("Skipping unsupported default value for column {} in table {}. Using NULL constraint instead.", (Object)column.getName(), (Object)tablePath.getFullName());
            }
            sqlBuilder.append(" NULL");
        }
        ddlSQL.add(sqlBuilder.toString());
        if (column.getComment() != null) {
            ddlSQL.add(this.buildColumnCommentSQL(tablePath, column));
        }
        this.executeDDL(connection, ddlSQL);
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableChangeColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        if (event.getOldColumn() != null && !event.getColumn().getName().equals(event.getOldColumn())) {
            StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE ").append(this.tableIdentifier(tablePath)).append(" RENAME COLUMN ").append(this.quoteIdentifier(event.getOldColumn())).append(" TO ").append(this.quoteIdentifier(event.getColumn().getName()));
            ddlSQL.add(sqlBuilder.toString());
        }
        this.executeDDL(connection, ddlSQL);
        if (event.getColumn().getDataType() != null) {
            this.applySchemaChange(connection, tablePath, AlterTableModifyColumnEvent.modify((TableIdentifier)event.tableIdentifier(), (Column)event.getColumn()));
        }
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableModifyColumnEvent event) throws SQLException {
        String columnType;
        Column column = event.getColumn();
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(column);
        String string = columnType = sameCatalog ? column.getSourceType() : typeDefine.getColumnType();
        if (event.getTypeChanged() != null && event.getTypeChanged().booleanValue() && "TEXT".equals(typeDefine.getColumnType())) {
            log.warn("DamengDB does not support modifying the TEXT type directly. Please use ALTER TABLE MODIFY COLUMN to change the column type.");
        }
        StringBuilder sqlBuilder = new StringBuilder("ALTER TABLE ").append(this.tableIdentifier(tablePath)).append(" MODIFY ").append(this.quoteIdentifier(column.getName())).append(" ").append(columnType);
        boolean targetColumnNullable = this.columnIsNullable(connection, tablePath, column.getName());
        if (column.isNullable() != targetColumnNullable && !targetColumnNullable) {
            sqlBuilder.append(" NULL ");
        }
        if (column.getDefaultValue() != null) {
            if (sameCatalog || !this.isSpecialDefaultValue(typeDefine.getDefaultValue(), sourceDialectName)) {
                String defaultValueClause = this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName);
                sqlBuilder.append(" ").append(defaultValueClause);
            } else {
                log.warn("Skipping unsupported default value for column {} in table {}.", (Object)column.getName(), (Object)tablePath.getFullName());
            }
        }
        ArrayList<String> ddlSQL = new ArrayList<String>();
        ddlSQL.add(sqlBuilder.toString());
        if (column.getComment() != null) {
            ddlSQL.add(this.buildColumnCommentSQL(tablePath, column));
        }
        this.executeDDL(connection, ddlSQL);
    }

    @Override
    public boolean needsQuotesWithDefaultValue(BasicTypeDefine columnDefine) {
        String dmDataType;
        switch (dmDataType = columnDefine.getDataType()) {
            case "CHAR": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "VARCHAR2": 
            case "NVARCHAR": 
            case "LONGVARCHAR": 
            case "CLOB": 
            case "TEXT": 
            case "LONG": {
                return true;
            }
        }
        return false;
    }

    private void executeDDL(Connection connection, List<String> ddlSQL) throws SQLException {
        try (Statement statement = connection.createStatement();){
            for (String sql : ddlSQL) {
                log.info("Executing DDL SQL: {}", (Object)sql);
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error executing DDL SQL: " + ddlSQL, e.getSQLState(), e);
        }
    }

    private String buildColumnCommentSQL(TablePath tablePath, Column column) {
        return String.format("COMMENT ON COLUMN %s.%s IS '%s'", this.tableIdentifier(tablePath), this.quoteIdentifier(column.getName()), column.getComment());
    }

    private boolean columnIsNullable(Connection connection, TablePath tablePath, String column) throws SQLException {
        String selectColumnSQL = "SELECT        NULLABLE FROM        ALL_TAB_COLUMNS c        WHERE c.owner = '" + tablePath.getSchemaName() + "'        AND c.table_name = '" + tablePath.getTableName() + "'        AND c.column_name = '" + column + "'";
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(selectColumnSQL);
            rs.next();
            boolean bl = rs.getString("NULLABLE").equals("Y");
            return bl;
        }
    }
}

