/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.Immutable;
import io.debezium.document.Array;
import io.debezium.document.BasicArray;
import io.debezium.document.BasicDocument;
import io.debezium.document.ConvertingValue;
import io.debezium.document.Document;
import io.debezium.document.Value;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

@Immutable
final class ComparableValue
implements Value {
    private static final Map<Class<?>, Value.Type> TYPES_BY_CLASS;
    private final Comparable<?> value;

    static Value.Type typeForValue(Value value) {
        assert (value != null);
        if (value.isNull()) {
            return Value.Type.NULL;
        }
        Value.Type type = TYPES_BY_CLASS.get(value.getClass());
        if (type != null) {
            return type;
        }
        if (value.isString()) {
            return Value.Type.STRING;
        }
        if (value.isBoolean()) {
            return Value.Type.BOOLEAN;
        }
        if (value.isBinary()) {
            return Value.Type.BINARY;
        }
        if (value.isInteger()) {
            return Value.Type.INTEGER;
        }
        if (value.isLong()) {
            return Value.Type.LONG;
        }
        if (value.isFloat()) {
            return Value.Type.FLOAT;
        }
        if (value.isDouble()) {
            return Value.Type.DOUBLE;
        }
        if (value.isBigInteger()) {
            return Value.Type.BIG_INTEGER;
        }
        if (value.isBigDecimal()) {
            return Value.Type.DECIMAL;
        }
        if (value.isDocument()) {
            return Value.Type.DOCUMENT;
        }
        if (value.isArray()) {
            return Value.Type.ARRAY;
        }
        if (value.isNull()) {
            return Value.Type.NULL;
        }
        assert (false);
        throw new IllegalStateException();
    }

    ComparableValue(Comparable<?> value) {
        assert (value != null);
        this.value = value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Value) {
            Value that = (Value)obj;
            if (this.isNumber() && that.isNumber()) {
                if (this.isLong()) {
                    return this.asLong().equals(that.asLong());
                }
                if (this.isDouble()) {
                    return this.asDouble().equals(that.asDouble());
                }
                if (this.isInteger()) {
                    return this.asInteger().equals(that.asInteger());
                }
                if (this.isFloat()) {
                    return this.asFloat().equals(that.asFloat());
                }
                if (this.isBigDecimal()) {
                    return this.asBigDecimal().equals(that.asBigDecimal());
                }
                if (this.isBigInteger()) {
                    return this.asBigInteger().equals(that.asBigInteger());
                }
            }
            return this.value.equals(that.asObject());
        }
        return this.value.equals(obj);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compareTo(Value that) {
        if (Value.isNull(that)) {
            return 1;
        }
        if (this.isBoolean() && that.isBoolean()) {
            return this.asBoolean().compareTo(that.asBoolean());
        }
        if (this.isNumber() && that.isNumber()) {
            if (this.isLong()) {
                return this.asLong().compareTo(that.asLong());
            }
            if (this.isDouble()) {
                return this.asDouble().compareTo(that.asDouble());
            }
            if (this.isInteger()) {
                return this.asInteger().compareTo(that.asInteger());
            }
            if (this.isFloat()) {
                return this.asFloat().compareTo(that.asFloat());
            }
            if (this.isBigDecimal()) {
                return this.asBigDecimal().compareTo(that.asBigDecimal());
            }
            return this.asBigInteger().compareTo(that.asBigInteger());
        }
        if (this.isDocument() && that.isDocument()) {
            return this.asDocument().compareTo(that.asDocument());
        }
        if (this.isArray() && that.isArray()) {
            return this.asArray().compareTo(that.asArray());
        }
        Object thisValue = this.asObject();
        Object thatValue = ((ComparableValue)that.comparable()).asObject();
        if (thisValue.getClass().isAssignableFrom(thatValue.getClass())) {
            return thisValue.compareTo(thatValue);
        }
        if (thatValue.getClass().isAssignableFrom(thisValue.getClass())) {
            return thatValue.compareTo(thisValue) * -1;
        }
        return this.value.compareTo(that.asObject());
    }

    @Override
    public Value.Type getType() {
        Value.Type type = TYPES_BY_CLASS.get(this.value.getClass());
        if (type == null) {
            if (this.isDocument()) {
                return Value.Type.DOCUMENT;
            }
            if (this.isArray()) {
                return Value.Type.ARRAY;
            }
            if (this.isNull()) {
                return Value.Type.NULL;
            }
        }
        assert (type != null);
        return type;
    }

    @Override
    public Comparable<?> asObject() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.isString() ? (String)((Object)this.value) : null;
    }

    @Override
    public Integer asInteger() {
        long raw;
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.value instanceof Long && ComparableValue.isValidInteger(raw = ((Long)this.value).longValue())) {
            return (int)raw;
        }
        return null;
    }

    private static boolean isValidInteger(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    private static boolean isValidFloat(double value) {
        return value >= (double)1.4E-45f && value <= 3.4028234663852886E38;
    }

    @Override
    public Long asLong() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.value instanceof Integer) {
            return ((Integer)this.value).longValue();
        }
        return null;
    }

    @Override
    public Boolean asBoolean() {
        return this.isBoolean() ? (Boolean)this.value : null;
    }

    @Override
    public Number asNumber() {
        return this.isNumber() ? (Number)((Number)((Object)this.value)) : (Number)null;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isBigInteger() ? (BigInteger)this.value : null;
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.isBigDecimal() ? (BigDecimal)this.value : null;
    }

    @Override
    public Float asFloat() {
        double raw;
        if (this.value instanceof Float) {
            return (Float)this.value;
        }
        if (this.value instanceof Double && ComparableValue.isValidFloat(raw = ((Double)this.value).doubleValue())) {
            return Float.valueOf((float)raw);
        }
        if (this.value instanceof Number) {
            return Float.valueOf(((Number)((Object)this.value)).floatValue());
        }
        return null;
    }

    @Override
    public Double asDouble() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Float) {
            return ((Float)this.value).doubleValue();
        }
        if (this.value instanceof Number) {
            return ((Number)((Object)this.value)).doubleValue();
        }
        return null;
    }

    @Override
    public Document asDocument() {
        return this.isDocument() ? (Document)this.value : null;
    }

    @Override
    public Array asArray() {
        return this.isArray() ? (Array)this.value : null;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isInteger() {
        return this.value instanceof Integer || this.value instanceof Long && ComparableValue.isValidInteger((Long)this.value);
    }

    @Override
    public boolean isLong() {
        return this.value instanceof Long || this.value instanceof Integer;
    }

    @Override
    public boolean isFloat() {
        return this.value instanceof Float || this.value instanceof Double && ComparableValue.isValidFloat((Double)this.value);
    }

    @Override
    public boolean isDouble() {
        return this.value instanceof Double || this.value instanceof Float;
    }

    @Override
    public boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isBigInteger() {
        return this.value instanceof BigInteger || this.value instanceof Integer || this.value instanceof Long;
    }

    @Override
    public boolean isBigDecimal() {
        return this.value instanceof BigDecimal || this.value instanceof Float || this.value instanceof Double;
    }

    @Override
    public boolean isDocument() {
        return this.value instanceof Document;
    }

    @Override
    public boolean isArray() {
        return this.value instanceof Array;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public byte[] asBytes() {
        return null;
    }

    @Override
    public Value convert() {
        return new ConvertingValue(this);
    }

    @Override
    public Value clone() {
        if (this.isArray()) {
            return new ComparableValue(this.asArray().clone());
        }
        if (this.isDocument()) {
            return new ComparableValue(this.asDocument().clone());
        }
        return this;
    }

    static {
        HashMap types = new HashMap();
        types.put(String.class, Value.Type.STRING);
        types.put(Boolean.class, Value.Type.BOOLEAN);
        types.put(byte[].class, Value.Type.BINARY);
        types.put(Integer.class, Value.Type.INTEGER);
        types.put(Long.class, Value.Type.LONG);
        types.put(Float.class, Value.Type.FLOAT);
        types.put(Double.class, Value.Type.DOUBLE);
        types.put(BigInteger.class, Value.Type.BIG_INTEGER);
        types.put(BigDecimal.class, Value.Type.DECIMAL);
        types.put(BasicDocument.class, Value.Type.DOCUMENT);
        types.put(BasicArray.class, Value.Type.ARRAY);
        TYPES_BY_CLASS = types;
    }
}

