/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.shade.io.grpc.internal;

import java.io.Closeable;
import org.tikv.shade.io.grpc.internal.ForwardingDeframerListener;
import org.tikv.shade.io.grpc.internal.GrpcUtil;
import org.tikv.shade.io.grpc.internal.MessageDeframer;
import org.tikv.shade.io.grpc.internal.StreamListener;

final class SquelchLateMessagesAvailableDeframerListener
extends ForwardingDeframerListener {
    private final MessageDeframer.Listener delegate;
    private boolean closed;

    public SquelchLateMessagesAvailableDeframerListener(MessageDeframer.Listener delegate) {
        this.delegate = delegate;
    }

    @Override
    protected MessageDeframer.Listener delegate() {
        return this.delegate;
    }

    @Override
    public void messagesAvailable(StreamListener.MessageProducer producer) {
        if (this.closed) {
            if (producer instanceof Closeable) {
                GrpcUtil.closeQuietly((Closeable)((Object)producer));
            }
            return;
        }
        super.messagesAvailable(producer);
    }

    @Override
    public void deframerClosed(boolean hasPartialMessage) {
        this.closed = true;
        super.deframerClosed(hasPartialMessage);
    }

    @Override
    public void deframeFailed(Throwable cause) {
        this.closed = true;
        super.deframeFailed(cause);
    }
}

