/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSink;

@AutoService(value={Factory.class})
public class JdbcSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Jdbc";
    }

    private ReadonlyConfig getCatalogOptions(TableSinkFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        Optional catalogOptions = config.getOptional(ConnectorCommonOptions.CATALOG_OPTIONS);
        if (catalogOptions.isPresent()) {
            return ReadonlyConfig.fromMap(new HashMap((Map)catalogOptions.get()));
        }
        return config;
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        String tempTableName;
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        ReadonlyConfig catalogOptions = this.getCatalogOptions(context);
        Optional<String> optionalTable = config.getOptional(JdbcSinkOptions.TABLE);
        Optional optionalDatabase = config.getOptional(JdbcSinkOptions.DATABASE);
        if (!optionalTable.isPresent()) {
            optionalTable = Optional.of("${table_name}");
        }
        TableIdentifier tableId = catalogTable.getTableId();
        String sourceDatabaseName = tableId.getDatabaseName();
        String sourceSchemaName = tableId.getSchemaName();
        String pluginInputIdentifier = tableId.getTableName();
        String sinkDatabaseName = optionalDatabase.orElse("${database_name}");
        String sinkTableNameBefore = optionalTable.get();
        String[] sinkTableSplitArray = sinkTableNameBefore.split("\\.");
        String sinkTableName = sinkTableSplitArray[sinkTableSplitArray.length - 1];
        String sinkSchemaName = sinkTableSplitArray.length > 1 ? sinkTableSplitArray[sinkTableSplitArray.length - 2] : null;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)catalogOptions.get(JdbcSinkOptions.SCHEMA)))) {
            sinkSchemaName = (String)catalogOptions.get(JdbcSinkOptions.SCHEMA);
        }
        String prefix = (String)catalogOptions.get(JdbcSinkOptions.TABLE_PREFIX);
        String suffix = (String)catalogOptions.get(JdbcSinkOptions.TABLE_SUFFIX);
        if (StringUtils.isNotEmpty((CharSequence)prefix) || StringUtils.isNotEmpty((CharSequence)suffix)) {
            tempTableName = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + sinkTableName : sinkTableName;
            tempTableName = StringUtils.isNotEmpty((CharSequence)suffix) ? tempTableName + suffix : tempTableName;
        } else {
            tempTableName = sinkTableName;
        }
        String finalDatabaseName = sinkDatabaseName;
        if (StringUtils.isNotEmpty((CharSequence)sourceDatabaseName)) {
            finalDatabaseName = sinkDatabaseName.replace("${database_name}", sourceDatabaseName);
        }
        String finalSchemaName = sinkSchemaName != null ? (sourceSchemaName == null ? sinkSchemaName : sinkSchemaName.replace("${schema_name}", sourceSchemaName)) : null;
        String finalTableName = sinkTableName;
        if (StringUtils.isNotEmpty((CharSequence)pluginInputIdentifier)) {
            finalTableName = tempTableName.replace("${table_name}", pluginInputIdentifier);
        }
        TableIdentifier newTableId = TableIdentifier.of((String)tableId.getCatalogName(), (String)finalDatabaseName, (String)finalSchemaName, (String)finalTableName);
        catalogTable = CatalogTable.of((TableIdentifier)newTableId, (TableSchema)catalogTable.getTableSchema(), (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getComment(), (String)catalogTable.getCatalogName());
        Map map = config.toMap();
        if (catalogTable.getTableId().getSchemaName() != null) {
            map.put(JdbcSinkOptions.TABLE.key(), catalogTable.getTableId().getSchemaName() + "." + catalogTable.getTableId().getTableName());
        } else {
            map.put(JdbcSinkOptions.TABLE.key(), catalogTable.getTableId().getTableName());
        }
        map.put(JdbcSinkOptions.DATABASE.key(), catalogTable.getTableId().getDatabaseName());
        PrimaryKey primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        if (!config.getOptional(JdbcSinkOptions.PRIMARY_KEYS).isPresent()) {
            if (primaryKey != null && !CollectionUtils.isEmpty((Collection)primaryKey.getColumnNames())) {
                map.put(JdbcSinkOptions.PRIMARY_KEYS.key(), String.join((CharSequence)",", primaryKey.getColumnNames()));
            } else {
                Optional<ConstraintKey> keyOptional = catalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> ConstraintKey.ConstraintType.UNIQUE_KEY.equals((Object)key.getConstraintType())).findFirst();
                if (keyOptional.isPresent()) {
                    map.put(JdbcSinkOptions.PRIMARY_KEYS.key(), keyOptional.get().getColumnNames().stream().map(key -> key.getColumnName()).collect(Collectors.joining(",")));
                }
            }
        } else {
            PrimaryKey configPk = PrimaryKey.of((String)(catalogTable.getTablePath().getTableName() + "_config_pk"), (List)((List)config.get(JdbcSinkOptions.PRIMARY_KEYS)));
            TableSchema tableSchema = catalogTable.getTableSchema();
            catalogTable = CatalogTable.of((TableIdentifier)catalogTable.getTableId(), (TableSchema)TableSchema.builder().primaryKey(configPk).constraintKey(tableSchema.getConstraintKeys()).columns(tableSchema.getColumns()).build(), (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getComment(), (String)catalogTable.getCatalogName());
        }
        ReadonlyConfig options = config = ReadonlyConfig.fromMap(new HashMap(map));
        JdbcSinkConfig sinkConfig = JdbcSinkConfig.of(config);
        FieldIdeEnum fieldIdeEnum = (FieldIdeEnum)((Object)config.get(JdbcSinkOptions.FIELD_IDE));
        catalogTable.getOptions().put("fieldIde", fieldIdeEnum == null ? null : fieldIdeEnum.getValue());
        JdbcDialect dialect = JdbcDialectLoader.load(sinkConfig.getJdbcConnectionConfig().getUrl(), sinkConfig.getJdbcConnectionConfig().getCompatibleMode(), sinkConfig.getJdbcConnectionConfig().getDialect(), fieldIdeEnum == null ? null : fieldIdeEnum.getValue());
        dialect.connectionUrlParse(sinkConfig.getJdbcConnectionConfig().getUrl(), sinkConfig.getJdbcConnectionConfig().getProperties(), dialect.defaultParameter());
        CatalogTable finalCatalogTable = catalogTable;
        DataSaveMode dataSaveMode = (DataSaveMode)config.get(JdbcSinkOptions.DATA_SAVE_MODE);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)config.get(JdbcSinkOptions.SCHEMA_SAVE_MODE);
        return () -> new JdbcSink(options, sinkConfig, dialect, schemaSaveMode, dataSaveMode, finalCatalogTable);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{JdbcSinkOptions.URL, JdbcSinkOptions.DRIVER, JdbcSinkOptions.SCHEMA_SAVE_MODE, JdbcSinkOptions.DATA_SAVE_MODE}).optional(new Option[]{JdbcSinkOptions.CREATE_INDEX, JdbcSinkOptions.USERNAME, JdbcSinkOptions.PASSWORD, JdbcSinkOptions.CONNECTION_CHECK_TIMEOUT_SEC, JdbcSinkOptions.BATCH_SIZE, JdbcSinkOptions.IS_EXACTLY_ONCE, JdbcSinkOptions.GENERATE_SINK_SQL, JdbcSinkOptions.AUTO_COMMIT, JdbcSinkOptions.PRIMARY_KEYS, JdbcSinkOptions.IS_PRIMARY_KEY_UPDATED, JdbcSinkOptions.SUPPORT_UPSERT_BY_INSERT_ONLY, JdbcSinkOptions.USE_COPY_STATEMENT, JdbcSinkOptions.COMPATIBLE_MODE, JdbcSinkOptions.ENABLE_UPSERT, JdbcSinkOptions.FIELD_IDE, JdbcSinkOptions.TABLE_PREFIX, JdbcSinkOptions.TABLE_SUFFIX, SinkConnectorCommonOptions.MULTI_TABLE_SINK_REPLICA, JdbcSinkOptions.DIALECT}).conditional(JdbcSinkOptions.IS_EXACTLY_ONCE, (Object)true, new Option[]{JdbcSinkOptions.XA_DATA_SOURCE_CLASS_NAME, JdbcSinkOptions.MAX_COMMIT_ATTEMPTS, JdbcSinkOptions.TRANSACTION_TIMEOUT_SEC}).conditional(JdbcSinkOptions.IS_EXACTLY_ONCE, (Object)false, new Option[]{JdbcSinkOptions.MAX_RETRIES}).conditional(JdbcSinkOptions.GENERATE_SINK_SQL, (Object)true, new Option[]{JdbcSinkOptions.DATABASE}).conditional(JdbcSinkOptions.GENERATE_SINK_SQL, (Object)false, new Option[]{JdbcSinkOptions.QUERY}).conditional(JdbcSinkOptions.DATA_SAVE_MODE, (Object)DataSaveMode.CUSTOM_PROCESSING, new Option[]{JdbcSinkOptions.CUSTOM_SQL}).build();
    }
}

