/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class PostgresTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(PostgresTypeConverter.class);
    public static final String PG_BOOLEAN = "bool";
    public static final String PG_BOOLEAN_ARRAY = "_bool";
    public static final String PG_BYTEA = "bytea";
    public static final String PG_SMALLINT = "int2";
    public static final String PG_SMALLSERIAL = "smallserial";
    public static final String PG_SMALLINT_ARRAY = "_int2";
    public static final String PG_INTEGER = "int4";
    public static final String PG_SERIAL = "serial";
    public static final String PG_INTEGER_ARRAY = "_int4";
    public static final String PG_BIGINT = "int8";
    public static final String PG_BIGSERIAL = "bigserial";
    public static final String PG_BIGINT_ARRAY = "_int8";
    public static final String PG_REAL = "float4";
    public static final String PG_REAL_ARRAY = "_float4";
    public static final String PG_DOUBLE_PRECISION = "float8";
    public static final String PG_DOUBLE_PRECISION_ARRAY = "_float8";
    public static final String PG_NUMERIC = "numeric";
    public static final String PG_MONEY = "money";
    public static final String PG_CHAR = "char";
    public static final String PG_BPCHAR = "bpchar";
    public static final String PG_CHARACTER = "character";
    public static final String PG_CHAR_ARRAY = "_bpchar";
    public static final String PG_VARCHAR = "varchar";
    public static final String PG_INET = "inet";
    public static final String PG_CIDR = "cidr";
    public static final String PG_MAC_ADDR = "macaddr";
    public static final String PG_MAC_ADDR8 = "macaddr8";
    public static final String PG_CHARACTER_VARYING = "character varying";
    public static final String PG_VARCHAR_ARRAY = "_varchar";
    public static final String PG_TEXT = "text";
    public static final String PG_TEXT_ARRAY = "_text";
    public static final String PG_JSON = "json";
    public static final String PG_JSONB = "jsonb";
    public static final String PG_XML = "xml";
    public static final String PG_UUID = "uuid";
    private static final String PG_GEOMETRY = "geometry";
    private static final String PG_GEOGRAPHY = "geography";
    public static final String PG_DATE = "date";
    public static final String PG_INTERVAL = "interval";
    public static final String PG_TIME = "time";
    public static final String PG_TIME_TZ = "timetz";
    public static final String PG_TIMESTAMP = "timestamp";
    public static final String PG_TIMESTAMP_TZ = "timestamptz";
    public static final int MAX_PRECISION = 1000;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 999;
    public static final int DEFAULT_SCALE = 18;
    public static final int MAX_TIME_SCALE = 6;
    public static final int MAX_TIMESTAMP_SCALE = 6;
    public static final int MAX_VARCHAR_LENGTH = 0xA00000;
    public static final PostgresTypeConverter INSTANCE = new PostgresTypeConverter();

    public String identifier() {
        return "Postgres";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String pgDataType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (pgDataType = typeDefine.getDataType().toLowerCase()) {
            case "bool": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "_bool": {
                builder.dataType((SeaTunnelDataType)ArrayType.BOOLEAN_ARRAY_TYPE);
                break;
            }
            case "smallserial": 
            case "int2": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "_int2": {
                builder.dataType((SeaTunnelDataType)ArrayType.SHORT_ARRAY_TYPE);
                break;
            }
            case "int4": 
            case "serial": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "_int4": {
                builder.dataType((SeaTunnelDataType)ArrayType.INT_ARRAY_TYPE);
                break;
            }
            case "int8": 
            case "bigserial": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "_int8": {
                builder.dataType((SeaTunnelDataType)ArrayType.LONG_ARRAY_TYPE);
                break;
            }
            case "float4": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "_float4": {
                builder.dataType((SeaTunnelDataType)ArrayType.FLOAT_ARRAY_TYPE);
                break;
            }
            case "float8": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "_float8": {
                builder.dataType((SeaTunnelDataType)ArrayType.DOUBLE_ARRAY_TYPE);
                break;
            }
            case "numeric": {
                DecimalType decimalType = typeDefine.getPrecision() != null && typeDefine.getPrecision() > 0L ? new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()) : new DecimalType(38, 18);
                builder.dataType((SeaTunnelDataType)decimalType);
                break;
            }
            case "money": {
                DecimalType moneyDecimalType = new DecimalType(30, 2);
                builder.dataType((SeaTunnelDataType)moneyDecimalType);
                builder.columnLength(Long.valueOf(30L));
                builder.scale(Integer.valueOf(2));
                break;
            }
            case "char": 
            case "bpchar": 
            case "character": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(TypeDefineUtils.charTo4ByteLength(1L));
                    builder.sourceType(pgDataType);
                    break;
                }
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                builder.sourceType(String.format("%s(%s)", pgDataType, typeDefine.getLength()));
                break;
            }
            case "varchar": 
            case "character varying": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.sourceType(pgDataType);
                    break;
                }
                builder.sourceType(String.format("%s(%s)", pgDataType, typeDefine.getLength()));
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "text": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "uuid": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.sourceType(pgDataType);
                builder.columnLength(Long.valueOf(128L));
                break;
            }
            case "json": 
            case "jsonb": 
            case "xml": 
            case "geometry": 
            case "geography": 
            case "inet": 
            case "interval": 
            case "cidr": 
            case "macaddr": 
            case "macaddr8": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.sourceType(pgDataType);
                break;
            }
            case "_bpchar": 
            case "_varchar": 
            case "_text": {
                builder.dataType((SeaTunnelDataType)ArrayType.STRING_ARRAY_TYPE);
                break;
            }
            case "bytea": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "date": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "time": 
            case "timetz": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                if (typeDefine.getScale() != null && typeDefine.getScale() > 6) {
                    builder.scale(Integer.valueOf(6));
                    log.warn("The scale of time type is larger than {}, it will be truncated to {}", (Object)6, (Object)6);
                    break;
                }
                builder.scale(typeDefine.getScale());
                break;
            }
            case "timestamp": 
            case "timestamptz": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                if (typeDefine.getScale() != null && typeDefine.getScale() > 6) {
                    builder.scale(Integer.valueOf(6));
                    log.warn("The scale of timestamp type is larger than {}, it will be truncated to {}", (Object)6, (Object)6);
                    break;
                }
                builder.scale(typeDefine.getScale());
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)this.identifier(), (String)typeDefine.getDataType(), (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        block0 : switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(PG_BOOLEAN);
                builder.dataType(PG_BOOLEAN);
                break;
            }
            case TINYINT: 
            case SMALLINT: {
                builder.columnType(PG_SMALLINT);
                builder.dataType(PG_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(PG_INTEGER);
                builder.dataType(PG_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(PG_BIGINT);
                builder.dataType(PG_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(PG_REAL);
                builder.dataType(PG_REAL);
                break;
            }
            case DOUBLE: {
                builder.columnType(PG_DOUBLE_PRECISION);
                builder.dataType(PG_DOUBLE_PRECISION);
                break;
            }
            case DECIMAL: {
                if (column.getSourceType() != null && column.getSourceType().equalsIgnoreCase(PG_MONEY)) {
                    builder.columnType(PG_MONEY);
                    builder.dataType(PG_MONEY);
                    break;
                }
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 1000L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 1000L));
                    precision = 1000L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 1000, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 999) {
                    scale = 999;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 999, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", PG_NUMERIC, precision, scale));
                builder.dataType(PG_NUMERIC);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                builder.columnType(PG_BYTEA);
                builder.dataType(PG_BYTEA);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(PG_TEXT);
                    builder.dataType(PG_TEXT);
                    break;
                }
                if (column.getColumnLength() <= 0xA00000L) {
                    builder.columnType(String.format("%s(%s)", PG_VARCHAR, column.getColumnLength()));
                    builder.dataType(PG_VARCHAR);
                    break;
                }
                builder.columnType(PG_TEXT);
                builder.dataType(PG_TEXT);
                break;
            }
            case DATE: {
                builder.columnType(PG_DATE);
                builder.dataType(PG_DATE);
                break;
            }
            case TIME: {
                Integer timeScale = column.getScale();
                if (timeScale != null && timeScale > 6) {
                    timeScale = 6;
                    log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 999, timeScale});
                }
                if (timeScale != null && timeScale > 0) {
                    builder.columnType(String.format("%s(%s)", PG_TIME, timeScale));
                } else {
                    builder.columnType(PG_TIME);
                }
                builder.dataType(PG_TIME);
                builder.scale(timeScale);
                break;
            }
            case TIMESTAMP: {
                Integer timestampScale = column.getScale();
                if (timestampScale != null && timestampScale > 6) {
                    timestampScale = 6;
                    log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 6, timestampScale});
                }
                if (timestampScale != null && timestampScale > 0) {
                    builder.columnType(String.format("%s(%s)", PG_TIMESTAMP, timestampScale));
                } else {
                    builder.columnType(PG_TIMESTAMP);
                }
                builder.dataType(PG_TIMESTAMP);
                builder.scale(timestampScale);
                break;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)column.getDataType();
                SeaTunnelDataType elementType = arrayType.getElementType();
                switch (elementType.getSqlType()) {
                    case BOOLEAN: {
                        builder.columnType(PG_BOOLEAN_ARRAY);
                        builder.dataType(PG_BOOLEAN_ARRAY);
                        break block0;
                    }
                    case TINYINT: 
                    case SMALLINT: {
                        builder.columnType(PG_SMALLINT_ARRAY);
                        builder.dataType(PG_SMALLINT_ARRAY);
                        break block0;
                    }
                    case INT: {
                        builder.columnType(PG_INTEGER_ARRAY);
                        builder.dataType(PG_INTEGER_ARRAY);
                        break block0;
                    }
                    case BIGINT: {
                        builder.columnType(PG_BIGINT_ARRAY);
                        builder.dataType(PG_BIGINT_ARRAY);
                        break block0;
                    }
                    case FLOAT: {
                        builder.columnType(PG_REAL_ARRAY);
                        builder.dataType(PG_REAL_ARRAY);
                        break block0;
                    }
                    case DOUBLE: {
                        builder.columnType(PG_DOUBLE_PRECISION_ARRAY);
                        builder.dataType(PG_DOUBLE_PRECISION_ARRAY);
                        break block0;
                    }
                    case BYTES: {
                        builder.columnType(PG_BYTEA);
                        builder.dataType(PG_BYTEA);
                        break block0;
                    }
                    case STRING: {
                        builder.columnType(PG_TEXT_ARRAY);
                        builder.dataType(PG_TEXT_ARRAY);
                        break block0;
                    }
                }
                throw CommonError.convertToConnectorTypeError((String)"Postgres", (String)elementType.getSqlType().name(), (String)column.getName());
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"Postgres", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

