/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkOptions;

public class JdbcConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String url;
    private String driverName;
    private String compatibleMode;
    private int connectionCheckTimeoutSeconds = (Integer)JdbcCommonOptions.CONNECTION_CHECK_TIMEOUT_SEC.defaultValue();
    private int maxRetries = (Integer)JdbcSinkOptions.MAX_RETRIES.defaultValue();
    private String username;
    private String password;
    private String query;
    private boolean autoCommit = (Boolean)JdbcSinkOptions.AUTO_COMMIT.defaultValue();
    private int batchSize = (Integer)JdbcSinkOptions.BATCH_SIZE.defaultValue();
    private String xaDataSourceClassName;
    private boolean decimalTypeNarrowing = (Boolean)JdbcCommonOptions.DECIMAL_TYPE_NARROWING.defaultValue();
    private boolean intTypeNarrowing = (Boolean)JdbcCommonOptions.INT_TYPE_NARROWING.defaultValue();
    private int maxCommitAttempts = (Integer)JdbcSinkOptions.MAX_COMMIT_ATTEMPTS.defaultValue();
    private int transactionTimeoutSec = (Integer)JdbcSinkOptions.TRANSACTION_TIMEOUT_SEC.defaultValue();
    private boolean useKerberos = (Boolean)JdbcCommonOptions.USE_KERBEROS.defaultValue();
    private String kerberosPrincipal;
    private String kerberosKeytabPath;
    private String krb5Path = (String)JdbcCommonOptions.KRB5_PATH.defaultValue();
    private String dialect = (String)JdbcCommonOptions.DIALECT.defaultValue();
    private Map<String, String> properties;
    private boolean handleBlobAsString = (Boolean)JdbcCommonOptions.HANDLE_BLOB_AS_STRING.defaultValue();

    public static JdbcConnectionConfig of(ReadonlyConfig config) {
        Builder builder = JdbcConnectionConfig.builder();
        builder.url((String)config.get(JdbcCommonOptions.URL));
        builder.compatibleMode((String)config.get(JdbcCommonOptions.COMPATIBLE_MODE));
        builder.driverName((String)config.get(JdbcCommonOptions.DRIVER));
        builder.autoCommit((Boolean)config.get(JdbcSinkOptions.AUTO_COMMIT));
        builder.maxRetries((Integer)config.get(JdbcSinkOptions.MAX_RETRIES));
        builder.connectionCheckTimeoutSeconds((Integer)config.get(JdbcCommonOptions.CONNECTION_CHECK_TIMEOUT_SEC));
        builder.batchSize((Integer)config.get(JdbcSinkOptions.BATCH_SIZE));
        builder.handleBlobAsString((Boolean)config.get(JdbcCommonOptions.HANDLE_BLOB_AS_STRING));
        if (((Boolean)config.get(JdbcSinkOptions.IS_EXACTLY_ONCE)).booleanValue()) {
            builder.xaDataSourceClassName((String)config.get(JdbcSinkOptions.XA_DATA_SOURCE_CLASS_NAME));
            builder.maxCommitAttempts((Integer)config.get(JdbcSinkOptions.MAX_COMMIT_ATTEMPTS));
            builder.transactionTimeoutSec((Integer)config.get(JdbcSinkOptions.TRANSACTION_TIMEOUT_SEC));
            builder.maxRetries(0);
        }
        if (((Boolean)config.get(JdbcCommonOptions.USE_KERBEROS)).booleanValue()) {
            builder.useKerberos((Boolean)config.get(JdbcCommonOptions.USE_KERBEROS));
            builder.kerberosPrincipal((String)config.get(JdbcCommonOptions.KERBEROS_PRINCIPAL));
            builder.kerberosKeytabPath((String)config.get(JdbcCommonOptions.KERBEROS_KEYTAB_PATH));
            builder.krb5Path((String)config.get(JdbcCommonOptions.KRB5_PATH));
        }
        config.getOptional(JdbcCommonOptions.USERNAME).ifPresent(builder::username);
        config.getOptional(JdbcCommonOptions.PASSWORD).ifPresent(builder::password);
        config.getOptional(JdbcCommonOptions.PROPERTIES).ifPresent(builder::properties);
        config.getOptional(JdbcCommonOptions.DECIMAL_TYPE_NARROWING).ifPresent(builder::decimalTypeNarrowing);
        config.getOptional(JdbcCommonOptions.INT_TYPE_NARROWING).ifPresent(builder::intTypeNarrowing);
        config.getOptional(JdbcCommonOptions.DIALECT).ifPresent(builder::dialect);
        return builder.build();
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public Optional<Integer> getTransactionTimeoutSec() {
        return this.transactionTimeoutSec < 0 ? Optional.empty() : Optional.of(this.transactionTimeoutSec);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isHandleBlobAsString() {
        return this.handleBlobAsString;
    }

    public void setHandleBlobAsString(boolean handleBlobAsString) {
        this.handleBlobAsString = handleBlobAsString;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getCompatibleMode() {
        return this.compatibleMode;
    }

    public int getConnectionCheckTimeoutSeconds() {
        return this.connectionCheckTimeoutSeconds;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public boolean isDecimalTypeNarrowing() {
        return this.decimalTypeNarrowing;
    }

    public boolean isIntTypeNarrowing() {
        return this.intTypeNarrowing;
    }

    public int getMaxCommitAttempts() {
        return this.maxCommitAttempts;
    }

    public boolean isUseKerberos() {
        return this.useKerberos;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getKerberosKeytabPath() {
        return this.kerberosKeytabPath;
    }

    public String getKrb5Path() {
        return this.krb5Path;
    }

    public String getDialect() {
        return this.dialect;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class Builder {
        private String url;
        private String driverName;
        private String compatibleMode;
        private int connectionCheckTimeoutSeconds = (Integer)JdbcCommonOptions.CONNECTION_CHECK_TIMEOUT_SEC.defaultValue();
        private int maxRetries = (Integer)JdbcSinkOptions.MAX_RETRIES.defaultValue();
        private String username;
        private String password;
        private String query;
        private boolean autoCommit = (Boolean)JdbcSinkOptions.AUTO_COMMIT.defaultValue();
        private int batchSize = (Integer)JdbcSinkOptions.BATCH_SIZE.defaultValue();
        private String xaDataSourceClassName;
        private boolean decimalTypeNarrowing = (Boolean)JdbcCommonOptions.DECIMAL_TYPE_NARROWING.defaultValue();
        private boolean intTypeNarrowing = (Boolean)JdbcCommonOptions.INT_TYPE_NARROWING.defaultValue();
        private boolean handleBlobAsString = (Boolean)JdbcCommonOptions.HANDLE_BLOB_AS_STRING.defaultValue();
        private int maxCommitAttempts = (Integer)JdbcSinkOptions.MAX_COMMIT_ATTEMPTS.defaultValue();
        private int transactionTimeoutSec = (Integer)JdbcSinkOptions.TRANSACTION_TIMEOUT_SEC.defaultValue();
        private Map<String, String> properties;
        public boolean useKerberos = (Boolean)JdbcCommonOptions.USE_KERBEROS.defaultValue();
        public String kerberosPrincipal;
        public String kerberosKeytabPath;
        public String krb5Path = (String)JdbcCommonOptions.KRB5_PATH.defaultValue();
        public String dialect = (String)JdbcCommonOptions.DIALECT.defaultValue();

        private Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder driverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder compatibleMode(String compatibleMode) {
            this.compatibleMode = compatibleMode;
            return this;
        }

        public Builder connectionCheckTimeoutSeconds(int connectionCheckTimeoutSeconds) {
            this.connectionCheckTimeoutSeconds = connectionCheckTimeoutSeconds;
            return this;
        }

        public Builder decimalTypeNarrowing(boolean decimalTypeNarrowing) {
            this.decimalTypeNarrowing = decimalTypeNarrowing;
            return this;
        }

        public Builder intTypeNarrowing(boolean intTypeNarrowing) {
            this.intTypeNarrowing = intTypeNarrowing;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder xaDataSourceClassName(String xaDataSourceClassName) {
            this.xaDataSourceClassName = xaDataSourceClassName;
            return this;
        }

        public Builder maxCommitAttempts(int maxCommitAttempts) {
            this.maxCommitAttempts = maxCommitAttempts;
            return this;
        }

        public Builder transactionTimeoutSec(int transactionTimeoutSec) {
            this.transactionTimeoutSec = transactionTimeoutSec;
            return this;
        }

        public Builder useKerberos(boolean useKerberos) {
            this.useKerberos = useKerberos;
            return this;
        }

        public Builder kerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        public Builder kerberosKeytabPath(String kerberosKeytabPath) {
            this.kerberosKeytabPath = kerberosKeytabPath;
            return this;
        }

        public Builder krb5Path(String krb5Path) {
            this.krb5Path = krb5Path;
            return this;
        }

        public Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder handleBlobAsString(boolean handleBlobAsString) {
            this.handleBlobAsString = handleBlobAsString;
            return this;
        }

        public JdbcConnectionConfig build() {
            JdbcConnectionConfig jdbcConnectionConfig = new JdbcConnectionConfig();
            jdbcConnectionConfig.batchSize = this.batchSize;
            jdbcConnectionConfig.driverName = this.driverName;
            jdbcConnectionConfig.compatibleMode = this.compatibleMode;
            jdbcConnectionConfig.maxRetries = this.maxRetries;
            jdbcConnectionConfig.password = this.password;
            jdbcConnectionConfig.connectionCheckTimeoutSeconds = this.connectionCheckTimeoutSeconds;
            jdbcConnectionConfig.url = this.url;
            jdbcConnectionConfig.autoCommit = this.autoCommit;
            jdbcConnectionConfig.username = this.username;
            jdbcConnectionConfig.transactionTimeoutSec = this.transactionTimeoutSec;
            jdbcConnectionConfig.maxCommitAttempts = this.maxCommitAttempts;
            jdbcConnectionConfig.xaDataSourceClassName = this.xaDataSourceClassName;
            jdbcConnectionConfig.decimalTypeNarrowing = this.decimalTypeNarrowing;
            jdbcConnectionConfig.intTypeNarrowing = this.intTypeNarrowing;
            jdbcConnectionConfig.handleBlobAsString = this.handleBlobAsString;
            jdbcConnectionConfig.useKerberos = this.useKerberos;
            jdbcConnectionConfig.kerberosPrincipal = this.kerberosPrincipal;
            jdbcConnectionConfig.kerberosKeytabPath = this.kerberosKeytabPath;
            jdbcConnectionConfig.krb5Path = this.krb5Path;
            jdbcConnectionConfig.dialect = this.dialect;
            jdbcConnectionConfig.properties = this.properties == null ? new HashMap() : this.properties;
            return jdbcConnectionConfig;
        }
    }
}

